% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/e_conversion.R
\name{aw2k}
\alias{ad2e}
\alias{ad2k}
\alias{ad2w}
\alias{ae2d}
\alias{ae2k}
\alias{ae2w}
\alias{ak2d}
\alias{ak2e}
\alias{ak2w}
\alias{aw2d}
\alias{aw2e}
\alias{aw2k}
\alias{de2a}
\alias{de2k}
\alias{de2w}
\alias{dk2a}
\alias{dk2e}
\alias{dk2w}
\alias{dw2a}
\alias{dw2e}
\alias{dw2k}
\alias{ek2a}
\alias{ek2d}
\alias{ek2w}
\alias{ew2a}
\alias{ew2d}
\alias{ew2k}
\alias{kd2a}
\alias{kd2e}
\alias{kd2w}
\alias{ke2a}
\alias{ke2d}
\alias{ke2w}
\alias{kw2a}
\alias{kw2d}
\alias{kw2e}
\title{Local Conversion Functions Between Kiener Distribution Parameters}
\usage{
aw2k(a, w)

aw2d(a, w)

aw2e(a, w)

ad2e(a, d)

ad2k(a, d)

ad2w(a, d)

ae2d(a, e)

ae2k(a, e)

ae2w(a, e)

ak2d(a, k)

ak2e(a, k)

ak2w(a, k)

de2a(d, e)

de2k(d, e)

de2w(d, e)

dk2a(d, k)

dk2e(d, k)

dk2w(d, k)

dw2a(d, w)

dw2e(d, w)

dw2k(d, w)

ek2a(e, k)

ek2d(e, k)

ek2w(e, k)

ew2a(e, w)

ew2d(e, w)

ew2k(e, w)

kd2a(k, d)

kd2e(k, d)

kd2w(k, d)

ke2a(k, e)

ke2d(k, e)

ke2w(k, e)

kw2a(k, w)

kw2d(k, w)

kw2e(k, w)
}
\arguments{
\item{a}{a numeric value.}

\item{w}{a numeric value.}

\item{d}{a numeric value.}

\item{e}{a numeric value.}

\item{k}{a numeric value.}
}
\description{
Conversion functions between parameters \code{a}, \code{k}, \code{w},
\code{d}, \code{e} used in Kiener distributions K2, K3 and K4.
}
\details{
\code{a} (alpha) is the left tail parameter,
\code{w} (omega) is the right tail parameter,
\code{d} (delta) is the distortion parameter,
\code{e} (epsilon) is the eccentricity parameter.
\code{k} (kappa) is the harmonic mean of \code{a} and \code{w} and
describes a global tail parameter.
They are defined by:
\deqn{ aw2k(a, w) = k = 2 / (1/a + 1/w) = \frac{2}{\frac{1}{a} +\frac{1}{w}}  }
\deqn{ aw2d(a, w) = d = (-1/a + 1/w) / 2 = \frac{-\frac{1}{a} +\frac{1}{w}}{2} }
\deqn{ aw2e(a, w) = e = (a - w) / (a + w) = \frac{a-w}{a+w} }
\deqn{ kd2a(k, d) = a = 1 / ( 1/k - d) = \frac{1}{\frac{1}{k} - d} }
\deqn{ kd2w(k, d) = w = 1 / ( 1/k + d) = \frac{1}{\frac{1}{k} + d} }
\deqn{ ke2a(k, e) = a = k / (1 - e) = \frac{k}{1-e} }
\deqn{ ke2w(k, e) = w = k / (1 + e) = \frac{k}{1+e} }
\deqn{ ke2d(k, e) = d = e / k = \frac{e}{k} }
\deqn{ kd2e(k, d) = e = k * d }
\deqn{ de2k(k, e) = k = e / d = \frac{e}{d} }
}
\examples{
aw2k(4, 6); aw2d(4, 6); aw2e(4, 6)
outer(1:6, 1:6, aw2k)
}
\seealso{
The asymmetric Kiener distributions K2, K3, K4:
\code{\link{kiener2}}, \code{\link{kiener3}}, \code{\link{kiener4}}
}

