% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fileSystem.R
\name{listFiles}
\alias{listFiles}
\title{List Only Files in a Directory}
\usage{
listFiles(dirPath, ...)
}
\arguments{
\item{dirPath}{Character. The path to the directory from which to list files.}

\item{...}{Additional arguments passed to \code{\link[base:list.files]{base::list.files()}} (e.g.,
\code{pattern}, \code{recursive}). Note that \code{full.names} will be ignored.}
}
\value{
A character vector of file paths.
}
\description{
This function lists only the files in a specified directory, excluding
directories. It is useful when you need to process or analyze only the files
within a directory without including subdirectories. The \code{\link[base:list.files]{base::list.files()}}
function lists both files and directories, so this function provides a more
convenient way to obtain just the files.
}
\examples{
\donttest{
listFiles(getwd())
listFiles(getwd(), pattern = "\\\\.R$", recursive = TRUE)
}

}
\keyword{fileSystem}
