% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.FastStepGraph.R
\name{cv.FastStepGraph}
\alias{cv.FastStepGraph}
\title{Searches for the optimal combination of alpha_f and alpha_b parameters using Cross-Validation}
\usage{
cv.FastStepGraph(
  x,
  n_folds = 5,
  alpha_f_min = 0.1,
  alpha_f_max = 0.9,
  n_alpha = 32,
  nei.max = 5,
  data_scale = FALSE,
  data_shuffle = TRUE,
  parallel = FALSE,
  n_cores = NULL
)
}
\arguments{
\item{x}{Data matrix (of size n x p).}

\item{n_folds}{Number of folds for the cross-validation procedure (default value 5).}

\item{alpha_f_min}{Minimum threshold value for the cross-validation procedure (default value 0.1).}

\item{alpha_f_max}{Minimum threshold value for the cross-validation procedure  (default value 0.9).}

\item{n_alpha}{Number of elements in the grid for the cross-validation (default value 32).}

\item{nei.max}{Maximum number of variables in every neighborhood (default value 5).}

\item{data_scale}{Boolean parameter (TRUE or FALSE), when to scale data to zero mean and unit variance (default FALSE).}

\item{data_shuffle}{Boolean parameter (default TRUE), when samples (rows of X) must be randomly shuffled.}

\item{parallel}{Boolean parameter (TRUE or FALSE), when to run Cross-Validation in parallel using a multicore architecture (default FALSE).}

\item{n_cores}{An 'int' value specifying the number of cores do you want to use if 'parallel=TRUE'. 
If n_cores is not specified, the maximum number of cores on your machine minus one will be set automatically.}
}
\value{
A list with the values: \cr \cr
\item{\code{alpha_f_opt}}{the optimal alpha_f value.}
\item{\code{alpha_f_opt}}{the optimal alpha_f value.}
\item{\code{CV.loss}}{minimum loss.}
\item{\code{vareps}}{Response variables.}
\item{\code{beta}}{Regression coefficients.}
\item{\code{Edges}}{Estimated set of edges.}
\item{\code{Omega}}{Estimated precision matrix.}
}
\description{
\code{cv.FastStepGraph} implements the cross-validation for the Fast Step Graph algorithm.
}
\examples{
data <- FastStepGraph::SigmaAR(30, 50, 0.4) # Simulate Gaussian Data
res <- FastStepGraph::cv.FastStepGraph(data$X)
}
\author{
Prof. Juan G. Colonna, PhD. \email{juancolonna@icomp.ufam.edu.br}

Prof. Marcelo Ruiz, PhD. \email{mruiz@exa.unrc.edu.ar}
}
