% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.jmcs.R
\name{fitted}
\alias{fitted}
\alias{fitted.jmcs}
\title{Fitted values for joint models}
\usage{
\method{fitted}{jmcs}(
  object,
  type = c("Marginal", "Subject"),
  process = c("Longitudinal", "Event"),
  ...
)
}
\arguments{
\item{object}{an object inheriting from class \code{jmcs}.}

\item{type}{for which type of fitted values to calculate.}

\item{process}{for which sub-model to calculate the fitted values.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a numeric vector of fitted values.
}
\description{
Extract fitted values for joint models.
}
\examples{
\donttest{
fit <- jmcs(ydata = ydata, cdata = cdata, 
long.formula = response ~ time + x1, 
surv.formula = Surv(surv, failure_type) ~ x1 + x2, 
random =  ~ time| ID)

# fitted for the longitudinal process
head(cbind(
  "Marg" = fitted(fit, type = "Marginal", process = "Longitudinal"), 
  "Subj" = fitted(fit, type = "Subject", process = "Longitudinal")
))
# fitted for the levent process - marginal survival function
head(fitted(fit, type = "Marginal", process = "Event"))
}

}
\author{
Shanpeng Li \email{lishanpeng0913@ucla.edu}
}
