% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FarmTest.R
\name{plot.farm.test}
\alias{plot.farm.test}
\title{Plot function of FarmTest}
\usage{
\method{plot}{farm.test}(x, ...)
}
\arguments{
\item{x}{A \code{farm.test} object.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
No variable will be returned, but a histogram of estimated means will be presented.
}
\description{
This is the plot function of S3 objects with class "\code{farm.test}". It produces the histogram of estimated means.
}
\details{
For two-sample FarmTest, the histogram is based on the difference: estimated means of sample \code{X} - estimated means of sample \code{Y}.
}
\examples{
n = 50
p = 100
K = 3
muX = rep(0, p)
muX[1:5] = 2
epsilonX = matrix(rnorm(p * n, 0, 1), nrow = n)
BX = matrix(runif(p * K, -2, 2), nrow = p)
fX = matrix(rnorm(K * n, 0, 1), nrow = n)
X = rep(1, n) \%*\% t(muX) + fX \%*\% t(BX) + epsilonX
output = farm.test(X)
plot(output)
}
\seealso{
\code{\link{farm.test}}, \code{\link{print.farm.test}} and \code{\link{summary.farm.test}}.
}
