% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PikeNYPartial2.R
\docType{data}
\name{PikeNYPartial2}
\alias{PikeNYPartial2}
\title{Capture histories (4 samples) of a subset of Northern Pike from Buckthorn Marsh.}
\format{
A data frame with 69 observations on the following 2 variables.
 \describe{
   \item{sample}{Name of the sample taken}
   \item{id}{Unique fish identification numbers}
 }
}
\source{
Simulated from summary data in Table C-1 of New York Power Authority. 2004. Use of Buckhorn Marsh and Grand Island tributaries by Northern Pike for spawning and as a nursery. Technical report, New York Power Authority, January 2004. Niagara Power Project (FERC No. 2216). \href{https://raw.githubusercontent.com/fishR-Core-Team/FSAdata/main/data-raw/PikeNYPartial2.csv}{CSV file}
}
\description{
Capture histories (4 samples), in capture-by-date format, of a subset of Northern Pike from Buckthorn Marsh.
}
\details{
Each line consists of the date and unique fish identification number over four samples of northern pike (\emph{Esox lucius}) in Buckthorn Marsh. This file contains the capture histories for only those pike captured from April 1-4.
}
\section{Topic(s)}{

 \itemize{
   \item Population Size
   \item Abundance
   \item Mark-Recapture
   \item Capture-Recapture
   \item Schnabel
   \item Schumacher-Eschmeyer
   \item Capture History
 }
}

\examples{
data(PikeNYPartial2)
str(PikeNYPartial2)
head(PikeNYPartial2)

}
\concept{Abundance}
\concept{Capture History}
\concept{Capture-Recapture}
\concept{Mark-Recapture}
\concept{Population Size}
\concept{Schnabel}
\keyword{datasets}
