context("bootstrap utilities OUTPUT")
source("EXS_bootstrap.R")

test_that("nlsBoot() methods output types",{
  # testing confint()
  tmp <- confint(nlsBoot1)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
  expect_equal(rownames(tmp),c("B1","B2","B3"))
  expect_equal(nrow(tmp),3)
  expect_equal(ncol(tmp),2)
  tmp <- confint(nlsBoot1,"B1")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
  expect_equal(rownames(tmp),c("B1"))
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  tmp <- confint(nlsBoot1,c(1,3))
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
  expect_equal(rownames(tmp),c("B1","B3"))
  expect_equal(nrow(tmp),2)
  expect_equal(ncol(tmp),2)
  # testing htest()
  tmp <- htest(nlsBoot1,"B1")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(colnames(tmp),c("Ho Value","p value"))
  expect_equal(rownames(tmp),c("B1"))
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  tmp <- htest(nlsBoot1,1)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(colnames(tmp),c("Ho Value","p value"))
  expect_equal(rownames(tmp),c("B1"))
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  # testing predict()
  tmp <- predict(nlsBoot1,fnx,days=3)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(colnames(tmp),c("days","Median","95% LCI","95% UCI"))
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),4)
  expect_equal(tmp[,"days"],c(days=3))
  tmp <- predict(nlsBoot1,fnx,days=1:5)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(colnames(tmp),c("days","Median","95% LCI","95% UCI"))
  expect_equal(nrow(tmp),5)
  expect_equal(ncol(tmp),4)
  expect_equal(tmp[,"days"],1:5)
  # get same output when digits are used?
  tmp <- predict(nlsBoot1,fnx,days=1:5,digits=2)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(colnames(tmp),c("days","Median","95% LCI","95% UCI"))
  expect_equal(nrow(tmp),5)
  expect_equal(ncol(tmp),4)
  expect_equal(tmp[,"days"],1:5)
})

test_that("bootCase() methods output types",{
  # testing confint()
  tmp <- confint(bootCase1)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
  expect_equal(rownames(tmp),c("B1","B2","B3"))
  expect_equal(nrow(tmp),3)
  expect_equal(ncol(tmp),2)
  tmp <- confint(bootCase1,"B1")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
  expect_equal(rownames(tmp),c("B1"))
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  tmp <- confint(bootCase1,c(1,3))
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
  expect_equal(rownames(tmp),c("B1","B3"))
  expect_equal(nrow(tmp),2)
  expect_equal(ncol(tmp),2)
  # testing htest()
  tmp <- htest(bootCase1,"B1")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(colnames(tmp),c("Ho Value","p value"))
  expect_equal(rownames(tmp),c("B1"))
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  tmp <- htest(bootCase1,1)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(colnames(tmp),c("Ho Value","p value"))
  expect_equal(rownames(tmp),c("B1"))
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  # testing predict()
  tmp <- predict(bootCase1,fnx,days=3)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(colnames(tmp),c("days","Median","95% LCI","95% UCI"))
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),4)
  expect_equal(tmp[,"days"],c(days=3))
  tmp <- predict(bootCase1,fnx,days=1:5)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(colnames(tmp),c("days","Median","95% LCI","95% UCI"))
  expect_equal(nrow(tmp),5)
  expect_equal(ncol(tmp),4)
  expect_equal(tmp[,"days"],1:5)
  # get same output when digits are used?
  tmp <- predict(nlsBoot1,fnx,days=1:5,digits=2)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(colnames(tmp),c("days","Median","95% LCI","95% UCI"))
  expect_equal(nrow(tmp),5)
  expect_equal(ncol(tmp),4)
  expect_equal(tmp[,"days"],1:5)
})
