% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/psdVal.R
\name{psdVal}
\alias{psdVal}
\title{Finds Gabelhouse lengths (for PSD calculations) for a species.}
\usage{
psdVal(species = "List", units = c("mm", "cm", "in"), incl.zero = TRUE,
  addLens = NULL, addNames = NULL)
}
\arguments{
\item{species}{A string that contains the species name for which to find Gabelhous lengths.  See details.}

\item{units}{A string that indicates the units for the returned lengths.  Choices are \code{mm} for millimeters (DEFAULT), \code{cm} for centimeters, and \code{in} for inches.}

\item{incl.zero}{A logical that indicates if a zero is included in the first position of the returned vector (DEFAULT) or not.  This position will be names as \dQuote{substock}.  See details.}

\item{addLens}{A numeric vector that contains minimum length definitions for additional categories.  See details.}

\item{addNames}{A string vector that contains names for the additional length categories added with \code{addLens}.  See details.}
}
\value{
A vector of minimum values for length categories for the chosen species.
}
\description{
Returns a vector with the five Gabelhouse lengths for a chosen species.
}
\details{
Finds the Gabelhouse lengths from the \code{data(PSDlit)} data frame for the species given in \code{species}.  The species name must be spelled exactly (within capitalization differences) as it appears in \code{data(PSDlit)} (type \code{psdVal()} to see the list of species and how they are spelled).

A zero is included in the first postion of the returned vector if \code{incl.zero=TRUE}.  This is useful when computing PSD values with a data.frame that contains fish smaller than the stock length.

Additional lengths can be added to the returned vector with \code{addLens}.  Names for these lengths can be included in \code{addNames}.  If \code{addNames} is non-NULL then it must be of the same length as \code{addLens}.  If \code{addLens} is non-NULL but \code{addNames} is NULL then the default names will be the same as the lengths in \code{addLens}.  The \code{addLens} argument is useful for calculating PSD values that are different from the Gabelhouse lengths.
}
\section{IFAR Chapter}{
 6-Size Structure.
}
\examples{
# List all of the species
psdVal()
# Demonstrate typical usages
psdVal("Yellow perch")
psdVal("Walleye",units="cm")
psdVal("Bluegill",units="in")
psdVal("Bluegill",units="in",incl.zero=FALSE)
psdVal("Bluegill")
# Demonstrate that it will work with mis-capitalization
psdVal("bluegill")
psdVal("Yellow Perch")
# Demonstrate adding in user-defined categories
psdVal("Bluegill",units="in",addLens=7)
psdVal("Bluegill",units="in",addLens=7,addNames="MinLen")
psdVal("Bluegill",units="in",addLens=c(7,9),addNames=c("MinSlot","MaxSlot"))
psdVal("Bluegill",units="in",addLens=c("MinLen"=7))
psdVal("Bluegill",units="in",addLens=c("MinSlot"=7,"MaxSlot"=9))
}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\references{
Ogle, D.H.  2015.  \href{http://derekogle.com/IFAR}{Introductory Fisheries Analyses with R}.  Chapman & Hall/CRC, Boca Raton, FL.

Guy, C.S., R.M. Neumann, and D.W. Willis.  2006.  \href{http://pubstorage.sdstate.edu/wfs/415-F.pdf}{New terminology for proportional stock density (PSD) and relative stock density (RSD): proportional size structure (PSS).}  Fisheries 31:86-87.

Guy, C.S., R.M. Neumann, D.W. Willis, and R.O. Anderson.  2006.  \href{http://pubstorage.sdstate.edu/wfs/450-F.pdf}{Proportional size distribution (PSD): A further refinement of population size structure index terminology.}  Fisheries 32:348.

Willis, D.W., B.R. Murphy, and C.S. Guy.  1993.  \href{http://web1.cnre.vt.edu/murphybr/web/Readings/Willis\%20et\%20al.pdf}{Stock density indices: development, use, and limitations.}  Reviews in Fisheries Science 1:203-222.
}
\seealso{
See \code{\link{psdCalc}}, \code{\link{psdPlot}}, \code{\link{psdAdd}}, \code{\link{PSDlit}}, \code{\link{tictactoe}}, \code{\link{lencat}}, and \code{\link{rcumsum}} for related functionality.
}
\keyword{manip}

