% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ports2TAGS.R
\name{BAStag2TAGS}
\alias{BAStag2TAGS}
\title{Function to write down twilights annotated in BAStag package data in so-called TAGS format}
\usage{
BAStag2TAGS(raw, twl, threshold, filename = NULL)
}
\arguments{
\item{raw}{original data - dataframe with two columns first column must contain time and second measured light levels}

\item{twl}{twilights object from \code{preprocess.light} function}

\item{threshold}{threshold value used for twilight definition in \code{preprocess.light}}

\item{filename}{if NULL data.frame in TAGS format will be returned otherwise .csv file in TAGS format will be written}
}
\value{
\code{NULL} if \code{filename} is provided or TAGS formatted dataframe.
}
\description{
this function converts combines twilights detected in BAStag with raw data and writes them down in TAGS format that can be easily read by \code{\link{get.tags.data}}
}
\details{
TAGS format returned or written as .csv by this function is a dataframe with columns
 \itemize{
   \item{\code{datetime}}{ date and time in ISO 8601 format e.g. 2013-06-16T00:00:11.000Z}
  \item{\code{light}}{ light value measured by tag}
  \item{\code{twilight}}{ assigned by the software numeric indication of whether the record belongs to sunrise (1), sunset (2) or none of those (0)}
  \item{\code{excluded}}{ indication of whether a twilight was excluded during manual inspection (logical, \code{TRUE | FALSE})}
  \item{\code{interp}}{ indication of whether the light value at twilight was interpolated (logical, \code{TRUE | FALSE})}
 }
The fields \code{excluded} and \code{interp} may have values of \code{TRUE} only for \code{twilight > 0}.
}
\seealso{
\code{\link{twGeos2TAGS}} and \code{\link{GeoLight2TAGS}}
}
\author{
Eldar Rakhimberdiev & Simeon Lisovski
}
