% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_particle_filter.R
\name{run.particle.filter}
\alias{run.particle.filter}
\title{Run Particle Filter}
\usage{
run.particle.filter(all.out, cpus = NULL, threads = -1,
  nParticles = 1e+06, known.last = TRUE, precision.sd = 25,
  behav.mask.low.value = 0, k = NA, plot = TRUE, cluster.type = "PSOCK",
  a = 45, b = 1500, L = 90, adaptive.resampling = 0.99,
  check.outliers = FALSE, sink2file = FALSE, add.jitter = FALSE)
}
\arguments{
\item{all.out}{An object created by \code{\link{make.prerun.object}}.}

\item{cpus}{another way to specify  \code{threads}}

\item{threads}{An amount of threads to use while running in parallel. default is -1. if value 1 submitted package will run sequentially}

\item{nParticles}{total amount of particles to be used with the run. 10 000 (1e4) is recommended for the preliminary run and 1 000 000 (1e6) for the final}

\item{known.last}{Set to FALSE if your bird was not at a known place during last twilight in the data}

\item{precision.sd}{if \code{known.last} then what is the precision of this information. Will be used to resample particles proportionally to their distance from the known last point with probability \code{P = dnorm(0, precision.sd)}}

\item{behav.mask.low.value}{Probability value that will be used instead of 0 in the behavioural mask. If set to 1 behavioural mask will not be active anymore}

\item{k}{Kappa parameter from vonMises distribution. Default is NA, otherwise will generate particles in a direction of a previous transitions with kappa = k}

\item{plot}{Should function plot preliminary map in the end of the run?}

\item{cluster.type}{see help to package parallel for details}

\item{a}{minimum distance that is used in the movement model - left boundary for truncated normal distribution of distances moved between twilights. Default is 45 for as default grid has a minimum distance of 50 km.}

\item{b}{Maximum distance allowed to fly between two consecutive twilights}

\item{L}{how many consecutive particles to resample}

\item{adaptive.resampling}{Above what level of ESS resampling should be skipped}

\item{check.outliers}{switches ON the online outlier routine}

\item{sink2file}{will write run details in a file instead of showing on the screen}

\item{add.jitter}{will add spatial jitter inside a grid cell for the median estimates}
}
\value{
FLightR object, containing output and extracted results. It is a list with the following elements 

   \item{Indices}{List with prior information and indices}
   \item{Spatial}{Spatial data - Grid, Mask, spatial likelihood}
   \item{Calibration}{all calibration parameters}
   \item{Data}{original data}
   \item{Results}{The main results object. Main components of it are
      \describe{
      \item{Quantiles}{dataframe containing results on locations. Each line corresponds to a twilight}
      \item{Movement.results}{dataframe containing all the movement results, Note - time at line n means time of the end of transition between n and n-1}
      \item{outliers}{id of twilights excluded by online outlier detection tool}
      \item{LL}{-Log likelihood}
      \item{Points.rle}{run length encoding object with posterior distribution for every twilight. Note that numbers of points correspond to line numbers in \code{$Spatial$Grid}}
      \item{Transitions.rle}{run length encoding object with all the transitions}
       }
  }
}
\description{
Main function of FLightR, it takes fully prepared object created by \code{\link{make.prerun.object}} and produces a result object that can be used for plotting etc.
}
\examples{
File<-system.file("extdata", "Godwit_TAGS_format.csv", package = "FLightR")
# to run example fast we will cut the real data file by 2013 Aug 20
Proc.data<-get.tags.data(File, end.date=as.POSIXct('2013-07-02', tz='GMT'))
Calibration.periods<-data.frame(
       calibration.start=NA,
       calibration.stop=as.POSIXct("2013-08-20"),
       lon=5.43, lat=52.93) 
       #use c() also for the geographic coordinates, if you have more than one calibration location
       # (e. g.,  lon=c(5.43, 6.00), lat=c(52.93,52.94))
print(Calibration.periods)

# NB Below likelihood.correction is set to FALSE for fast run! 
# Leave it as default TRUE for real examples
Calibration<-make.calibration(Proc.data, Calibration.periods, likelihood.correction=FALSE)

Grid<-make.grid(left=0, bottom=50, right=10, top=56,
  distance.from.land.allowed.to.use=c(-Inf, Inf),
  distance.from.land.allowed.to.stay=c(-Inf, Inf))

all.in<-make.prerun.object(Proc.data, Grid, start=c(5.43, 52.93),
                             Calibration=Calibration, threads=2)
# here we will run only 1e4 partilces for a very short track.
# One should use 1e6 particles for the full run.
Result<-run.particle.filter(all.in, threads=1,
           nParticles=1e3, known.last=TRUE,
           precision.sd=25, check.outliers=FALSE)

}
\author{
Eldar Rakhimberdiev
}
