% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cuerank_function.R
\name{cuerank}
\alias{cuerank}
\title{Calculates thresholds that maximize a statistic (goal) for cues.}
\usage{
cuerank(formula = NULL, data = NULL, goal.threshold = "bacc",
  sens.w = 0.5, cost.outcomes = list(hi = 0, fa = 1, mi = 1, cr = 0),
  cost.cues = NULL, numthresh.method = "o", numthresh.n = 20,
  rounding = NULL, cue.rules = NULL, quiet = FALSE)
}
\arguments{
\item{formula}{formula. A formula specifying a binary criterion as a function of multiple variables}

\item{data}{dataframe. A dataframe containing variables in formula}

\item{goal.threshold}{character. A string indicating the statistic to maximize when calculting cue thresholds: "acc" = overall accuracy, "wacc" = weighted accuracy, "bacc" = balanced accuracy}

\item{sens.w}{numeric. A number from 0 to 1 indicating how to weight sensitivity relative to specificity.}

\item{cost.outcomes}{list. A list of length 4 with names 'hi', 'fa', 'mi', and 'cr' specifying the costs of a hit, false alarm, miss, and correct rejection rspectively. E.g.; \code{cost.outcomes = listc("hi" = 0, "fa" = 10, "mi" = 20, "cr" = 0)} means that a false alarm and miss cost 10 and 20 respectively while correct decisions have no cost.}

\item{cost.cues}{dataframe. A dataframe with two columns specifying the cost of each cue. The first column should be a vector of cue names, and the second column should be a numeric vector of costs. Cues in the dataset not present in \code{cost.cues} are assume to have 0 cost.}

\item{numthresh.method}{character. A string indicating how to calculate cue splitting thresholds. "m" = median split, "o" = split that maximizes the goal,}

\item{numthresh.n}{integer. The maximum number of numeric thresholds to be considered.}

\item{rounding}{integer. An integer indicating digit rounding for non-integer numeric cue thresholds. The default is NULL which means no rounding. A value of 0 rounds all possible thresholds to the nearest integer, 1 rounds to the nearest .1 (etc.).}

\item{cue.rules}{dataframe. Optional existing dataframe of previously defined cue rules.}

\item{quiet}{logical. Should ongoing diagnostics be printed?}
}
\value{
A dataframe containing thresholds and marginal classification statistics for each cue
}
\description{
Calculates thresholds that maximize a statistic (goal) for cues.
}
\examples{

\dontrun{
 # What are the best thresholds for each cue in the mushrooms dataset?
 mushrooms.cues <- cuerank(formula = poisonous ~.,
                           data = mushrooms)
}


}
