% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applyfft_function.R
\name{applyfft}
\alias{applyfft}
\title{Applies a FFT to a data}
\usage{
applyfft(fft.object = NULL, which.trees = NULL, level.name.v = NULL,
  level.class.v = NULL, level.exit.v = NULL, level.threshold.v = NULL,
  level.sigdirection.v = NULL, cue.df = NULL, criterion.v = NULL,
  hr.weight = 0.5, correction = 0.25)
}
\arguments{
\item{fft.object}{(M) An fft object created from the fft() function.}

\item{which.trees}{An integer indicating which tree to plot (only valid when the tree argument is non-empty). To plot the best training (or test) tree with respect to v (HR - FAR), use "best.train" or "best.test"}

\item{level.name.v}{A character indicating the names of the levels in the tree separated by ;. For example "age;sex;occupation"}

\item{level.class.v}{(B) A character vector of length n indicating the class of the cues for each level. "F" = factor, "N" = numeric, "L" = logical.}

\item{level.exit.v}{(B) A numeric vector of length n indicating the exit direction for each level. 0 = noise clasification, 1 = signal decision, .5 = both.}

\item{level.threshold.v}{(M) A character indicating the level thresholds separated by ;. For example "25;female;occupation"}

\item{level.sigdirection.v}{(M) A character vector of length n indicating the direction for which exemplars are classified as signals for each cue. Values must be in the set "<" (strictly less than), "<=" (less than or equal to), "=" (equal), "!=" (unequal), ">=" (greater than or equal to), or ">" (strictly greater than)/}

\item{cue.df}{(M) An m x n dataframe containing n cue values for each of the m exemplars.}

\item{criterion.v}{(B) A logical vector of length m indicating the true class (e.g.; FALSE = noise, TRUE = signal) of each exemplar.}

\item{hr.weight}{A number between 0 and 1 indicating how much weight to give to the hit-rate when ranking cues. Default is 0.5.}

\item{correction}{An integer indicating how much to add to each cross-decision table cell in the case that at least one cell is 0.}
}
\value{
A list of length 3. The first element "decision.df" is a dataframe with the decisions (and level of decisions) for each exemplar. The second element, "final.df" is a dataframe showing final tree accuracy statistics. The third element "level.df" shows tree accuracy statistics at each level.
}
\description{
Applies a FFT to a data
}

