% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{update.femlm}
\alias{update.femlm}
\title{Updates a femlm estimation}
\usage{
\method{update}{femlm}(object, fml.update, ...)
}
\arguments{
\item{object}{An object of class \code{femlm}. Typically the result of a \code{\link[FENmlm]{femlm}} estimation.}

\item{fml.update}{Changes to be made to the original argument \code{fml}. See more information on \code{\link[stats]{update.formula}}. You can add/withdraw both variables and clusters. E.g. \code{. ~ . + x2 | . + z2} would add the variable \code{x2} and the cluster \code{z2} to the former estimation.}

\item{...}{Other arguments to be passed to the function \code{\link[FENmlm]{femlm}}.}
}
\value{
It returns a \code{\link[FENmlm]{femlm}} object (see details in \code{\link[FENmlm]{femlm}}.
}
\description{
Updates and re-estimates a \code{\link[FENmlm]{femlm}} model. This function updates the formulas and use previous starting values to estimate a new \code{\link[FENmlm]{femlm}} model. The data is obtained from the original \code{call}.
}
\examples{

# Example using trade data
data(trade)

# main estimation
est_pois <- femlm(Euros ~ log(dist_km) | Origin + Destination, trade)

# we add the variable log(Year)
est_2 <- update(est_pois, . ~ . + log(Year))

# we add another cluster: "Product"
est_3 <- update(est_2, . ~ . | . + Product)

# we remove the cluster "Origin" and the variable log(dist_km)
est_4 <- update(est_3, . ~ . - log(dist_km) | . - Origin)

# Quick look at the 4 estimations
res2table(est_pois, est_2, est_3, est_4)

}
\seealso{
\code{\link[FENmlm]{femlm}}, \code{\link[FENmlm]{predict.femlm}}, \code{\link[FENmlm]{summary.femlm}}, \code{\link[FENmlm]{vcov.femlm}}, \code{\link[FENmlm]{getFE}}.
}
\author{
Laurent Berge
}
