% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SinglePoly.R
\name{SinglePoly}
\alias{SinglePoly}
\title{SinglePoly}
\usage{
SinglePoly(x, y, ptDS, ptDL)
}
\arguments{
\item{x}{X-coordinates for geometry.}

\item{y}{Y-coordinates for geometry.}

\item{ptDS}{Density of points desired within the geometry.}

\item{ptDL}{Density of points desired at the perimeter of the geometry.}
}
\value{
Coordinate points of nodes distributed within and on the line of a given geometry.
\item{AllCoords}{all coordinate points distributed across the geometry.}
\item{Within}{all coordinate points within the geometry ONLY.}
\item{Line}{all coordinate points that lay on the perimeter of the geometry ONLY.}
}
\description{
Generates a mesh for polygon with a single continuous geometry
}
\examples{
data(Cart)

x = Cart[,1]
y= Cart[,2]
ptDS = 30
ptDL = 20

polyshape = SinglePoly(x, y, ptDS, ptDL)

}
