% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{reweightData}
\alias{reweightData}
\title{Function to Reweight Data}
\usage{
reweightData(data, argvals, vars, longvars = NULL, weights, index,
  idvars = NULL)
}
\arguments{
\item{data}{a named list or data.frame.}

\item{argvals}{character (vector); name(s) for entries in data giving
the index for observed grid points; must be supplied if \code{vars} is not supplied.}

\item{vars}{character (vector); name(s) for entries in data, which
are subsetted according to weights or index. Must be supplied if \code{argvals} is not supplied.}

\item{longvars}{variables in long format, e.g., a response that is observed at curve specific grids.}

\item{weights}{vector of weights for observations. Must be supplied if \code{index} is not supplied.}

\item{index}{vector of indices for observations. Must be supplied if \code{weights} is not supplied.}

\item{idvars}{character (vector); index, which is needed to expand \code{vars} to be conform
with the \code{hmatrix} structure when using \code{bhistx}-base-learners or to be conform with
variables in long format specified in \code{longvars}.}
}
\value{
A list with the reweighted or subsetted data.
}
\description{
Function to Reweight Data
}
\details{
\code{reweightData} indexes the rows of matrices and / or positions of vectors by using
either the \code{index} or the \code{weights}-argument. To prevent the function from indexing
the list entry / entries, which serve as time index for observed grid points of each trajectory of
functional observations, the \code{argvals} argument (vector of character names for these list entries)
can be supplied. If \code{argvals} is not supplied, \code{vars} must be supplied and it is assumed that
\code{argvals} is equal to \code{names(data)[!names(data) \%in\% vars]}.

When using \code{weights}, a weight vector of length N must be supplied, where N is the number of observations.
When using \code{index}, the vector must contain the index of each row as many times as it shall be included in the
new data set.
}
\examples{
## load data
data("viscosity", package = "FDboost")
interval <- "101"
end <- which(viscosity$timeAll == as.numeric(interval))
viscosity$vis <- log(viscosity$visAll[ , 1:end])
viscosity$time <- viscosity$timeAll[1:end]

## what does data look like
str(viscosity)

## do some reweighting
# correct weights
str(reweightData(viscosity, vars=c("vis", "T_C", "T_A", "rspeed", "mflow"),
    argvals = "time", weights = c(0, 32, 32, rep(0, 61))))

str(visNew <- reweightData(viscosity, vars=c("vis", "T_C", "T_A", "rspeed", "mflow"),
    argvals = "time", weights = c(0, 32, 32, rep(0, 61))))
# check the result
# visNew$vis[1:5, 1:5] ## image(visNew$vis)

# incorrect weights
str(reweightData(viscosity, vars=c("vis", "T_C", "T_A", "rspeed", "mflow"),
    argvals = "time", weights = sample(1:64, replace = TRUE)), 1)

# supply meaningful index
str(visNew <- reweightData(viscosity, vars = c("vis", "T_C", "T_A", "rspeed", "mflow"),
              argvals = "time", index = rep(1:32, each = 2)))
# check the result
# visNew$vis[1:5, 1:5]

# errors
if(FALSE){
   reweightData(viscosity, argvals = "")
   reweightData(viscosity, argvals = "covThatDoesntExist", index = rep(1,64))
   }
}
\author{
David Ruegamer, Sarah Brockhaus
}

