% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplifyFCS.R
\name{simplifyFCS}
\alias{simplifyFCS}
\title{Simplify FCS}
\usage{
simplifyFCS(g, tau, step = 1)
}
\arguments{
\item{g}{A vector containing the FCS data analysis}

\item{tau}{A vector that represents the time frame between data acquisitions}

\item{step}{A numeric value that affects the final length of the vector}
}
\value{
A vector of the FCS data with reduced length
}
\description{
Reduces the amount of data in a data set without altering its overall structure
}
\details{
Allows to significantly reduce the points of the autocorrelation vector, maintaining its overall structure and allowing to further adjust physical models while obtaining consistent results.
}
\examples{
\donttest{
f <- Cy5_100nM$f
acqTime <- 2E-6
f <- as.vector(f)
time <- (1:length(f))*acqTime
cy5 <- data.frame(t = time, f)

g <- fcs(x = cy5$f)
len <- 1:length(g)
tau <-cy5$t[len]
G <- data.frame(tau,g)

sfcs <- simplifyFCS(G$g, G$tau, step = 0.5)
plot(sfcs$g~sfcs$tau, log = "x", type = "l",
     xlab = expression(tau(s)),
     ylab = expression(G(tau)), main = "Cy5")

# Comparison, original with simplify
plot(G, type = 'l', log = 'x')
lines(sfcs$g~sfcs$tau, col = "red")
}
}
\seealso{
\code{\link{gcf}}, \code{\link{var}, \link{mean}}
}
\author{
Adan O. Guerrero
}
