% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mjmcmc.R
\name{mjmcmc}
\alias{mjmcmc}
\title{Main algorithm for MJMCMC (Genetically Modified MJMCMC)}
\usage{
mjmcmc(
  x,
  y,
  N = 1000,
  probs = NULL,
  params = NULL,
  loglik.pi = NULL,
  mlpost_params = list(family = "gaussian", beta_prior = list(type = "g-prior")),
  intercept = TRUE,
  fixed = 0,
  sub = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{matrix containing the design matrix with data to use in the algorithm,}

\item{y}{response variable}

\item{N}{The number of MJMCMC iterations to run for (default 100)}

\item{probs}{A list of various probability vectors used by GMJMCMC, generated by \code{gen.probs.mjmcmc}.}

\item{params}{A list of various parameter vectors used by MJMCMC, generated by \code{gen.params.mjmcmc}.}

\item{loglik.pi}{A function specifying the marginal log-posterior of the model up to a constant, including the logarithm of the model prior:
\eqn{\log p(M|Y) = \text{const} + \log p(Y|M) + \log p(M)}.
Typically assumes a Gaussian model with Zellner's g prior with \eqn{g = max(n,p^2) by default}.}

\item{mlpost_params}{All parameters for the estimator function loglik.pi}

\item{intercept}{Logical. Whether to include an intercept in the design matrix. Default is \code{TRUE}. No variable selection is performed on the intercept.}

\item{fixed}{Integer specifying the number of leading columns in the design matrix to always include in the model. Default is 0.}

\item{sub}{Logical. If \code{TRUE}, uses subsampling or a stochastic approximation approach to the likelihood rather than the full likelihood. Default is \code{FALSE}.}

\item{verbose}{Logical. Whether to print messages during execution. Default is \code{TRUE} for \code{gmjmcmc} and \code{FALSE} for the parallel version.}
}
\value{
A list containing the following elements:
\item{models}{All visited models in both mjmcmc and local optimization.}
\item{accept}{Average acceptance rate of the chain.}
\item{mc.models}{All models visited during mjmcmc iterations.}
\item{best.crit}{The highest log marginal probability of the visited models.}
\item{marg.probs}{Marginal probabilities of the features.}
\item{model.probs}{Marginal probabilities of all of the visited models.}
\item{model.probs.idx}{Indices of unique visited models.}
\item{populations}{The covariates represented as a list of features.}
}
\description{
Main algorithm for MJMCMC (Genetically Modified MJMCMC)
}
\examples{
result <- mjmcmc(
y = matrix(rnorm(100), 100),
x = matrix(rnorm(600), 100),
loglik.pi = gaussian.loglik)
summary(result)
plot(result)

}
