% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_scenario.R
\name{create_scenario}
\alias{create_scenario}
\title{Create Stressed Scenarios}
\usage{
create_scenario(model, subsamples, alpha = 0.95, fpr = FALSE)
}
\arguments{
\item{model}{An object of class \code{mldfm}, containing the factor estimates.}

\item{subsamples}{An object of class \code{mldfm_subsample}, returned by \code{mldfm_subsampling}.}

\item{alpha}{Numeric. Confidence level for the hyperellipsoids (e.g., 0.95).}

\item{fpr}{Logical. If \code{TRUE}, uses FPR Gamma (Fresoli, Poncela, Ruiz, 2024); otherwise, uses standard time-varying Gamma.}
}
\value{
An object of class \code{fars_scenario}, which is a list containing:
\describe{
\item{ellipsoids}{List of matrices defining the hyperellipsoids at each time.}
\item{center}{Matrix of factor estimates (centers of the ellipsoids).}
\item{sigma}{List of covariance matrices used to define the ellipsoids.}
\item{periods}{Number of time observations.}
\item{n_points}{Number of points used to define each ellipsoid.}
\item{alpha}{Confidence level for the hyperellipsoids.}
\item{call}{Function call.}
}
}
\description{
Constructs hyperellipsoids around MLDFM factor estimates using subsampling. These regions capture estimation uncertainty and allow for the simulation of stressed scenarios.
}
\examples{
\donttest{
data <- matrix(rnorm(100*300), nrow = 100, ncol = 300)
block_ind <- c(150, 300)  
global = 1
local <- c(1, 1)   
mldfm_result <- mldfm(data, blocks = 2, block_ind = block_ind, 
global = global, local = local)
mldfm_subsampling_result <- mldfm_subsampling(data, blocks = 2, 
block_ind = block_ind, global = global, 
local = local, n_samples = 100, sample_size = 0.9)
scenario <- create_scenario(mldfm_result, mldfm_subsampling_result, 
alpha = 0.95)
}

}
