% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code3.R
\name{ExtractByLine}
\alias{ExtractByLine}
\title{Add a Line shapefile and raster image.}
\usage{
ExtractByLine(img, line.shp, In.colName, Out.colName)
}
\arguments{
\item{img}{Raster image}

\item{line.shp}{Line shapefile with class info}

\item{In.colName}{Name of the column contain line id's}

\item{Out.colName}{Name of the output column contain line id's}
}
\description{
Add a Line shapefile and raster image.
}
\examples{
library(raster)
library(ExtractTrainData)
img<-brick(system.file("extdata","ras.tif",package = "ExtractTrainData"))
line.shp<-shapefile(system.file("extdata","lines.shp",package = "ExtractTrainData"))
Out.colName<-In.colName<-"Id"
ExtractByLine(img,line.shp,In.colName,Out.colName)
}
\author{
Subhadip Datta
}
