% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Triangular.R
\name{Triangular}
\alias{Triangular}
\alias{dTriangular}
\alias{pTriangular}
\alias{qTriangular}
\alias{rTriangular}
\alias{eTriangular}
\alias{lTriangular}
\title{The Triangular Distribution.}
\usage{
dTriangular(x, a = 0, b = 1, theta = 0.5, params = list(a, b, theta), ...)

pTriangular(q, a = 0, b = 1, theta = 0.5, params = list(a, b, theta), ...)

qTriangular(p, a = 0, b = 1, theta = 0.5, params = list(a, b, theta), ...)

rTriangular(n, a = 0, b = 1, theta = 0.5, params = list(a, b, theta), ...)

eTriangular(X, w, method = "numerical.MLE", ...)

lTriangular(
  X,
  w,
  a = 0,
  b = 1,
  theta = 0.5,
  params = list(a, b, theta),
  logL = TRUE,
  ...
)
}
\arguments{
\item{x, q}{A vector of quantiles.}

\item{a, b}{Boundary parameters.}

\item{theta}{Shape parameters.}

\item{params}{A list that includes all named parameters.}

\item{...}{Additional parameters.}

\item{p}{A vector of probabilities.}

\item{n}{Number of observations.}

\item{X}{Sample observations.}

\item{w}{An optional vector of sample weights.}

\item{method}{Parameter estimation method.}

\item{logL}{logical, it is assumed that the log-likelihood is desired. Set to FALSE if the likelihood is wanted.}
}
\value{
dTriangular gives the density, pTriangular the distribution function,
qTriangular the quantile function, rTriangular generates random variables, and 
eTriangular estimates the parameters. lTriangular provides the log-likelihood function.
}
\description{
Density, distribution, quantile, random number 
generation and parameter estimation functions for the triangular distribution with support \eqn{[a,b]} 
and \code{shape} parameter \eqn{\theta}. Parameter estimation can be based on a weighted or unweighted i.i.d. sample
and can be performed numerically.
}
\details{
If \code{a}, \code{b} or \code{theta} are not specified they assume the default values of 0, 1 and 0.5 respectively.\cr
\cr
The \code{dTriangle()}, \code{pTriangle()}, \code{qTriangle()},and \code{rTriangle()} functions serve as wrappers of the
\code{\link[VGAM]{dtriangle}}, \code{\link[VGAM]{ptriangle}}, \code{\link[VGAM]{qtriangle}}, and 
\code{\link[VGAM]{rtriangle}} functions in the \pkg{{VGAM}} package. They allow for the parameters to be declared not only as 
individual numerical values, but also as a list so parameter estimation can be carried out. \cr  
\cr
The triangular distribution has a probability density function, defined in Forbes et.al (2010), that consists of two lines joined at \eqn{theta}, 
where \eqn{theta} is the location of the mode.
}
\references{
Kotz, S. and van Dorp, J. R. (2004). Beyond Beta: Other Continuous
Families of Distributions with Bounded Support and Applications. Chapter 1.
World Scientific: Singapore.\cr
\cr
Forbes, C., Evans, M., Hastings, N. and Peacock, B. (2010) Triangular Distribution, 
in Statistical Distributions, Fourth Edition, John Wiley & Sons, Inc., Hoboken, NJ, USA.
}
\seealso{
\pkg{\link{ExtDist}} for other standard distributions.
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey. \cr
Updates and bug fixes by Sarah Pirikahu.
}
