% Generated by roxygen2 (4.0.0): do not edit by hand
\name{Beta}
\alias{Beta}
\alias{dBeta}
\alias{eBeta}
\alias{iBeta}
\alias{lBeta}
\alias{pBeta}
\alias{qBeta}
\alias{rBeta}
\alias{sBeta}
\title{The standard Beta Distribution.}
\usage{
dBeta(x, shape1 = 2, shape2 = 3, params = list(shape1, shape2))

pBeta(q, shape1 = 2, shape2 = 3, params = list(shape1, shape2))

qBeta(p, shape1 = 2, shape2 = 3, params = list(shape1, shape2))

rBeta(n, shape1 = 2, shape2 = 3, params = list(shape1, shape2))

eBeta(X, w, method = "numerical.MLE")

lBeta(X, w, shape1 = 2, shape2 = 3, params = list(shape1, shape2),
  logL = TRUE)

sBeta(X, w, shape1 = 2, shape2 = 3, params = list(shape1, shape2))

iBeta(X, w, shape1 = 2, shape2 = 3, params = list(shape1, shape2))
}
\arguments{
\item{params}{a list includes all parameters}

\item{x,q}{vector of quantiles.}

\item{w}{weights of sample.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{X}{sample observations.}

\item{shape1,shape2}{shape parameters.}

\item{method}{parameter estimation method.}

\item{logL}{logical; if TRUE, lBeta gives log likelihood.}

\item{...}{other parameters}
}
\value{
dBeta gives the density; pBeta gives the distribution function;
qBeta gives the quantile function; rBeta generates random variables;
eBeta estimate the parameters; sBeta gives observed scorn function
}
\description{
Density, distribution function, quantile function, random
generation function and parameter estimation function (based on weighted or
unweighted i.i.d. sample) for the Beta distribution
}
\details{
standard Beta Distribution

See \href{../doc/Distributions-Beta.html}{Distributions-Beta}
}
\examples{
\donttest{
# Parameter estimation
n <- 500
shape1 <- 1
shape2 <- 2
X <- rBeta(n, shape1, shape2)
(est.par <- eBeta(X))

# Histogram and fitted density
den.x <- seq(min(X),max(X),length=100)
den.y <- dBeta(den.x,shape1=est.par$shape1,shape2=est.par$shape2)
hist(X, breaks=10, col="red", probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue", lwd=2)

# Q-Q plot and P-P plot
plot(qBeta((1:n-0.5)/n, params=est.par), sort(X), main="Q-Q Plot", xlab="Theoretical Quantiles",
ylab="Sample Quantiles", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

plot((1:n-0.5)/n, pBeta(sort(X), params=est.par), main="P-P Plot", xlab="Theoretical Percentile",
ylab="Sample Percentile", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

# A weighted parameter estimation example
n <- 10
par <- list(shape1=1, shape2=2)
X <- rBeta(n, params=par)
w <- c(0.13, 0.06, 0.16, 0.07, 0.2, 0.01, 0.06, 0.09, 0.1, 0.12)
eBeta(X,w) # estimated parameters of weighted sample
eBeta(X) # estimated parameters of unweighted sample

# Alternative parameter estimation methods
(est.par <- eBeta(X, method = "numerical.MLE"))

# Extracting shape parameters
est.par[attributes(est.par)$par.type=="shape"]

# evaluate the performance of the parameter estimation function by simulation
eval.estimation(rdist=rBeta,edist=eBeta,n = 1000, rep.num = 1e3,
params = list(shape1=2, shape2=5), method ="numerical.MLE")
eval.estimation(rdist=rBeta,edist=eBeta,n = 1000, rep.num = 1e3,
params = list(shape1=2, shape2=5), method ="MOM")

# evaluate the precision of estimation by Hessian matrix
X <- rBeta(1000, shape1, shape2)
(est.par <- eBeta(X))
H <- attributes(eBeta(X, method = "numerical.MLE"))$nll.hessian
fisher_info <- solve(H)
sqrt(diag(fisher_info))

# log-likelihood, score vector and observed information matrix
lBeta(X,param = est.par)
lBeta(X,param = est.par, logL=FALSE)
sBeta(X,param = est.par)
iBeta(X,param = est.par)
}
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey
}

