% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_file.create.R
\name{shape_file.create}
\alias{shape_file.create}
\title{Funcao para criar as coordenadas dos objetos/parcelas na imagem}
\usage{
shape_file.create(im,rows=10,cols=6,rectangular=TRUE,colLines="white",
ColPlot="red",ColNumber="red",SelectSeveral=FALSE,Matrix=NULL)
}
\arguments{
\item{im}{:Este objeto deve conter uma imagem no formato do EBImage.}

\item{rows}{Numbers of rows (Numero de linhas).}

\item{cols}{Numbers of columns (Numero de colunas).}

\item{rectangular}{Valor logico. Se for TRUE sera feita uma correcao para as parcelas ficarem retangulares}

\item{colLines}{Nome da cor que as linhas tracadas serao apresentadas. Default e "white".}

\item{ColPlot}{Nome da cor que as linhas do grid a serem apresentadas. Default e "red".}

\item{ColNumber}{Nome da cor que de cada retangulo a serem apresentadas. Default e "red".}

\item{SelectSeveral}{Valor logico indicando se deseja-se desenhar mais de um grid. Default e FALSE.}

\item{Matrix}{Objeto com os grids criados anteriormente, caso exista. Default e NULL.}
}
\description{
Esta funcao cria um arquivo com as coordenadas dos vertices de cada objeto/parcela
de interesse na imagem.
}
\examples{
\dontrun{
end=example_image(13)
im=read_image(end,plot=TRUE)
A=shape_file.create(im,rows=5,cols=5,rectangular=F,Matrix=NULL,SelectSeveral = F)
B=shape_file.BorderExtract(im,A,p.rows = .9,p.cols = .9)
shape_file.plot(im,ShapeFile = B)
shape_file.split(im =im,shapefile = B,path = getwd(),namesFile = "TEST",type = ".jpg")
}
}
\seealso{
\code{\link{shape_file.BorderExtract}}, \code{\link{shape_file.split}}
}
