% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dic.r
\name{dic}
\alias{dic}
\title{Delineamento Inteiramente Casualizado Simples}
\usage{
dic(
  trat,
  resp,
  quali = TRUE,
  mcomp = "tukey",
  nl = FALSE,
  hvar = "bartlett",
  sigT = 0.05,
  sigF = 0.05
)
}
\arguments{
\item{trat}{Vetor numerico ou complexo contendo os
tratamentos.}

\item{resp}{Vetor numerico ou complexo contendo a variavel
resposta.}

\item{quali}{Logico. Se TRUE (default), os tratamentos sao
entendido como qualitativos, se FALSE, quantitativos.}

\item{mcomp}{Permite escolher o teste de comparacao
multipla; o \emph{default} e o teste de Tukey, contudo
tem-se como outras opcoes: o teste LSD ("lsd"), o teste LSDB
("lsdb"), o teste de Duncan ("duncan"), o teste de SNK
("snk"), o teste de Scott-Knott ("sk"), o teste de
comparacoes multiplas bootstrap ("ccboot") e o teste de
Calinski e Corsten baseado na distribuicao F ("ccf").}

\item{nl}{Logico. Escolhe se modelos nao lineares devem ser
ajustados aos fatores quantitativos. O default e FALSE.}

\item{hvar}{Permite escolher o teste de homogeneidade de
variancias; o \emph{default} e o teste de ONeill e Mathews
('oneilmathews'), contudo tem-se como outras  opcoes: o
teste de Han ('han') e o teste de Ascombe e Tukey
('ascombetukey').}

\item{sigT}{Significancia a ser adotada pelo teste de
comparacao multipla de medias; o default e 5\%.}

\item{sigF}{Significancia a ser adotada pelo teste F da
ANAVA; o default e 5\%.}
}
\value{
Sao retornados os valores da analise de variancia do
DIC em questao, o teste de normalidade de Shapiro-Wilk para
os residuos do modelo, o ajuste de modelos de regressao
(caso de tratamentos quantitativos) ou os testes de
comparacao de medias (caso de tratamentos qualitativos):
teste de Tukey, teste de Duncan, teste t de Student (LSD),
teste t de Bonferroni, teste de Student-Newman-Keuls(SNK),
teste de Scott-Knott  e teste de comparacoes multiplas
bootstrap.
}
\description{
\code{dic} Analisa experimentos em Delineamento Inteiramente
Casualizado balanceado com um so fator, considerando o
modelo fixo.
}
\details{
Os argumentos sigT e mcomp so serao utilizados
quando os tratamentos forem qualitativos.
}
\note{
O \code{\link{graficos}} pode ser usado para
construir os graficos da regressao e o
\code{\link{plotres}} para analise do residuo da anava.
}
\examples{
data(ex1)
attach(ex1)
dic(trat, ig, quali = FALSE, sigF = 0.05)
}
\references{
BANZATTO, D. A.; KRONKA, S. N. Experimentacao
Agricola. 4 ed. Jaboticabal: Funep. 2006. 237 p.

FERREIRA, E. B.; CAVALCANTI, P. P. Funcao em codigo R para
analisar experimentos em DIC simples, em uma so rodada. In:
REUNIAO ANUAL DA REGIAO BRASILEIRA DA SOCIEDADE
INTERNACIONAL DE BIOMETRIA, 54./SIMPOSIO DE ESTATISTICA
APLICADA A EXPERIMENTACAO AGRONOMICA, 13., 2009, Sao Carlos.
Programas e resumos... Sao Carlos, SP: UFSCar, 2009. p. 1-5.
}
\seealso{
\code{\link{fat2.dic}}, \code{\link{fat3.dic}},
\code{\link{psub2.dic}}, \code{\link{fat2.ad.dic}} and
\code{\link{fat3.ad.dic}}.
}
\author{
Eric B Ferreira,
 \email{eric.ferreira@unifal-mg.edu.br}

Denismar Alves Nogueira

Portya Piscitelli Cavalcanti
}
