% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rwalk.R
\name{rwalk}
\alias{rwalk}
\title{Simulate a random walk process using an `EViews` engine from R.}
\usage{
rwalk(series="",wf="",page="",drift=NA,rndseed=NA,frequency="m",
start_date="1990",end_date="2020",num_cross_sections=NA,num_observations=NA)
}
\arguments{
\item{series}{Names of series for the random walk.}

\item{wf}{Object or a character string representing the name of a workfile to be created}

\item{page}{Object or a character string representing the name of a workfile page to be created}

\item{drift}{Numeric value as the drift term for random walk.}

\item{rndseed}{Set the `seed` for `Eviews` random number generator.}

\item{frequency}{Object or a character string representing the frequency of a workfile page to be created. Only letters accepted by EViews are allowed. For example \code{u} for undated, \code{a} for annual, \code{m} for monthly and so on.}

\item{start_date}{Object or a character string representing the \code{start date}. It should be left blank for undated (when the \code{frequency} is \code{u}).}

\item{end_date}{Object or a character string representing the \code{end date}. It should be left blank for undated (when the \code{frequency} is \code{u}).}

\item{num_cross_sections}{Optional integer value. Include \code{num_cross_sections} in order to create an `EViews` balanced panel page using integer identifiers for each of the cross-sections.}

\item{num_observations}{Numeric value. Specify the number of observations if the \code{frequency="u"}.}
}
\value{
An EViews workfile
}
\description{
Use this function to simulate a random walk process using an `EViews` engine.
}
\examples{
library(EviewsR)
\dontrun{

rwalk(wf="",series="X Y Z",page="",rndseed=12345,frequency="M",
num_observations=100)

plot(eviews$XYZ[[2]],ylab = "EViewsR",type = "l",col="red")

}
}
\seealso{
eng_eviews, eviews_commands, eviews_graph, eviews_import, eviews_object, eviews_pagesave, rwalk, eviews_wfcreate, eviews_wfsave, export, import_table, import
}
\keyword{documentation}
