% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exec_commands.R
\name{exec_commands}
\alias{exec_commands}
\title{Execute `EViews` commands from R}
\usage{
exec_commands(commands="",wf="",page="")
}
\arguments{
\item{commands}{Object or a vector of character strings of `EViews` commands}

\item{wf}{Object or a character string representing the name of a workfile to be created}

\item{page}{Object or a character string representing the name of a workfile page to be created}
}
\value{
An EViews workfile
}
\description{
Use this function to execute `EViews` commands from R
}
\examples{
library(EviewsR)
\dontrun{
exec_commands(c("wfcreate(wf=Workfile,page=Page) m 2000 2022","save workfile","exit"))
exec_commands(c("genr y=rnd","y.line"),wf="Workfile")
unlink("workfile.wf1")
# The first example creates an `EViews` workfile with monthly frequency from 1990 2021,
# then save the workfile in the current working directory

# The second example opens the `EViews` workfile and then generate a random series
# named `y` and plot its line graph.
# The third line deletes the workfile from your directory.
}
}
\seealso{
eng_eviews, eviews_graph, eviews_import, create_object, eviews_pagesave, rwalk, eviews_wfcreate, eviews_wfsave, export, import_table, import
}
\keyword{documentation}
