% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesianMetaAnalysis.R
\name{computeBayesianMetaAnalysis}
\alias{computeBayesianMetaAnalysis}
\title{Compute a Bayesian random-effects meta-analysis}
\usage{
computeBayesianMetaAnalysis(
  data,
  chainLength = 1100000,
  burnIn = 1e+05,
  subSampleFrequency = 100,
  priorSd = c(2, 0.5),
  alpha = 0.05,
  robust = FALSE,
  df = 4,
  seed = 1,
  showProgressBar = TRUE
)
}
\arguments{
\item{data}{A data frame containing either normal, skew-normal, custom parametric,
or grid likelihood data, with one row per database.}

\item{chainLength}{Number of MCMC iterations.}

\item{burnIn}{Number of MCMC iterations to consider as burn in.}

\item{subSampleFrequency}{Subsample frequency for the MCMC.}

\item{priorSd}{A two-dimensional vector with the standard deviation of the prior for mu
and tau, respectively.}

\item{alpha}{The alpha (expected type I error) used for the credible intervals.}

\item{robust}{Whether or not to use a t-distribution model; default: FALSE.}

\item{df}{Degrees of freedom for the t-model, only used if robust is TRUE.}

\item{seed}{The seed for the random number generator.}

\item{showProgressBar}{Showing a progress bar for MCMC?}
}
\value{
A data frame with the point estimates and 95\% credible intervals for the mu and tau parameters (the
mean and standard deviation of the distribution from which the per-site effect sizes are drawn).
Attributes of the data frame contain the MCMC trace and the detected approximation type.
}
\description{
Compute a Bayesian meta-analysis using the Markov chain Monte Carlo (MCMC) engine BEAST.
A normal and half-normal prior are used for the mu and tau parameters, respectively, with standard
deviations as defined by the \code{priorSd} argument.
}
\examples{
# Simulate some data for this example:
populations <- simulatePopulations()

# Fit a Cox regression at each data site, and approximate likelihood function:
fitModelInDatabase <- function(population) {
  cyclopsData <- Cyclops::createCyclopsData(Surv(time, y) ~ x + strata(stratumId),
    data = population,
    modelType = "cox"
  )
  cyclopsFit <- Cyclops::fitCyclopsModel(cyclopsData)
  approximation <- approximateLikelihood(cyclopsFit, parameter = "x", approximation = "custom")
  return(approximation)
}
approximations <- lapply(populations, fitModelInDatabase)
approximations <- do.call("rbind", approximations)

# At study coordinating center, perform meta-analysis using per-site approximations:
estimate <- computeBayesianMetaAnalysis(approximations)
estimate

# (Estimates in this example will vary due to the random simulation)

}
\seealso{
\link{approximateLikelihood}, \link{computeFixedEffectMetaAnalysis}
}
