% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateEvents.R
\name{simulateEvents}
\alias{simulateEvents}
\title{Imposes simulated events on the top of the data}
\usage{
simulateEvents(Data, Params, Event_type, Event_strength = NULL,
  Start_index = NULL, Event_duration = NULL, Percentage = NULL)
}
\arguments{
\item{Data}{Data frame or matrix containing the data to which the events will be introduced}

\item{Params}{Numeric vector or vector of strings indicating the column names (in case Data is a data frame) or the column
numbers (in case Data is a matrix) of the parameters in which an event will be simulated}

\item{Event_type}{String vector indicating which type of transformation the parameters will undergo.
Current valid options include sinusoidal, square, ramp and slowsinusoidal. If Params contains more that one
element and Event_type only contains one element the same transformation will be applied to all given Params}

\item{Event_strength}{(Optional) Numeric Vector indicating the amplitude. Only valid for sinusoidal and square
transformations. When specified for other type of transformations it will have no effect. However it must have
the same number of elements as Params.}

\item{Start_index}{Numeric, indicates the index where the event should start}

\item{Event_duration}{Numeric, indicates the number of steps the transformation should last. Default is 100}

\item{Percentage}{(Optional) Numeric value from 0 to 1. Alternative input indicating the percentage of data that
should be affected by the transformation. Either Event_duration or Percentage should be especified.}
}
\value{
Matrix or data frame containing the selected columns with simulated events
}
\description{
Simulates Events on columns of a data frame or a matrix by applying different transformations.
The events of type sinusoidal, square, binomial or ramp can be used.
}
\examples{

#Generate event of type sinusoidal and ramp on two columns of the stationBData data set
simupar<-c("B_PH_VAL","B_TEMP_VAL")
SimulatedEvents<-simulateEvents(stationBData,
                                simupar,Event_type = c("sinusoidal","ramp"),
                                Start_index = 2500)

#When specifiying Event_strength the lenght of the vector needs to match the number
#of elements in Params.
SimulatedEvents<-simulateEvents(stationBData,
                                simupar,Event_type = c("sinusoidal","ramp"),
                                Start_index = 2500,
                                Percentage = 0.2,
                                Event_strength = c(4,1))

}
