% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisquare.evalueate.core.R
\name{chisquare.evaluate.core}
\alias{chisquare.evaluate.core}
\title{Chi-squared Test for Homogeneity}
\usage{
chisquare.evaluate.core(data, names, qualitative, selected)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string}

\item{qualitative}{Name of columns with the qualitative traits as a character
vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}
}
\value{
A a data frame with the following columns. \item{Trait}{The
  qualitative trait.} \item{EC_No.Classes}{The number of classes in the trait
  for EC.} \item{EC_Classes}{The frequency of the classes in the trait for
  EC.} \item{CS_No.Classes}{The number of classes in the trait for CS.}
  \item{CS_Classes}{The frequency of the classes in the trait for CS.}
  \item{chisq_statistic}{The \mjseqn{\chi^{2}} test statistic.}
  \item{chisq_pvalue}{The p value for the test statistic.}
  \item{chisq_significance}{The significance of the test statistic (*: p
  \mjseqn{\leq} 0.01; **: p \mjseqn{\leq} 0.05; ns: p \mjseqn{ > } 0.05).}
}
\description{
Compare the distribution frequencies of qualitative traits between entire
collection (EC) and core set (CS) by Chi-squared test for homogeneity
\insertCite{pearson_x._1900,snedecor_chi-square_1933}{EvaluateCore}.
\loadmathjax
}
\examples{

####################################
# Use data from R package ccChooser
####################################

library(ccChooser)
data("dactylis_CC")
data("dactylis_EC")

ec <- cbind(genotypes = rownames(dactylis_EC), dactylis_EC[, -1])
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) cut(x, breaks = 4))
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) factor(as.numeric(x)))
head(ec)

core <- rownames(dactylis_CC)

quant <- c("X2", "X3", "X4", "X5", "X8")
qual <- c("X1", "X6", "X7")

####################################
# EvaluateCore
####################################

chisquare.evaluate.core(data = ec, names = "genotypes",
                        qualitative = qual, selected = core)


}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[stats]{chisq.test}}
}
