% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_distfit.R
\name{expect_gaussian}
\alias{expect_gaussian}
\title{Test a Gaussian distribution}
\usage{
expect_gaussian(sample, p_value = 0.001)
}
\arguments{
\item{sample}{to test}

\item{p_value}{threshold p-value of the test}
}
\value{
Invisibly returns a p-value of the test.
}
\description{
Expectation checking whether a given sample comes from Gaussian distribution with arbitrary parameters. The underlying procedure is Shapiro- Wilk's test of normality \code{\link[stats]{shapiro.test}}.
The expectation throws an error when the test's p-value is smaller than the threshold p-value.
}
\details{
shapiro.test allows the number of non-missing values to be between 3 and 5000.
}
\examples{

x<-rnorm(n=1e3,5,6)
expect_gaussian(sample=x)

#The following test doesn't pass
\dontrun{
x<-runif(n=1e2,-1,6)
expect_gaussian(sample=x)
}
}
