% Generated by roxygen2 (4.0.1): do not edit by hand
\name{FCIplot}
\alias{FCIplot}
\title{FCIplot}
\usage{
FCIplot(series, plott = TRUE, wind1 = 24, wind2 = 60, k = 60,
  rrr1 = "Rec", rrr2 = "Rec", main = "series")
}
\arguments{
\item{series}{series to be plotted.}

\item{plott}{should a plot be created? default is \code{plott=TRUE}.}

\item{wind1}{window size for the AR component (see details).}

\item{wind2}{window size for the ARCH component (see details).}

\item{k}{if \code{plott=TRUE}, \code{tail(series,k)} will be plotted.}

\item{rrr1}{will the AR model be estimated using Recursive ("Rec") or
Rolling ("Rol") window?}

\item{rrr2}{will the ARCH model be estimated using Recursive ("Rec") or
Rolling ("Rol") window?}

\item{main}{main title of the plot, same as in \code{\link{plot.default}}.}
}
\value{
vector of prediction's standard deviation.
}
\description{
Estimate and plot prediction standard deviation. Given the series, the
function estimate point prediction based on AR(1) model and, using the
resdiuals from this simple model, estimate an ARCH model to estimate the
prediction standard deviation. If \code{plott=TRUE}, a plot of the most
recent \code{k} values is created.
}
\details{
Estimate and plot prediction confidence intervals based on AR-ARCH model.
}
\examples{
par(mfrow = c(2,1))
out <- FCIplot(rnorm(100),plott=TRUE,k=30)
plott(out,main="The out-of-sample standard deviation")
}

