% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{obs_opts}
\alias{obs_opts}
\title{Observation Model Options}
\usage{
obs_opts(
  family = c("negbin", "poisson"),
  dispersion = Normal(mean = 0, sd = 0.25),
  weight = 1,
  week_effect = TRUE,
  week_length = 7,
  scale = Fixed(1),
  na = c("missing", "accumulate"),
  likelihood = TRUE,
  return_likelihood = FALSE,
  phi
)
}
\arguments{
\item{family}{Character string defining the observation model. Options are
Negative binomial ("negbin"), the default, and Poisson.}

\item{dispersion}{A \verb{<dist_spec>} specifying a prior on the dispersion
parameter of the reporting process, used only if \code{familiy} is "negbin".
Internally parameterised such that this parameter is one over the square
root of the \code{phi} parameter for overdispersion of the
\href{https://mc-stan.org/docs/functions-reference/unbounded_discrete_distributions.html#neg-binom-2-log}{negative binomial distribution}. # nolint
Defaults to a half-normal distribution with mean of 0 and
standard deviation of 0.25: \code{Normal(mean = 0, sd = 0.25)}. A lower limit of
zero will be enforced automatically.}

\item{weight}{Numeric, defaults to 1. Weight to give the observed data in the
log density.}

\item{week_effect}{Logical defaulting to \code{TRUE}. Should a day of the week
effect be used in the observation model.}

\item{week_length}{Numeric assumed length of the week in days, defaulting to
7 days. This can be modified if data aggregated over a period other than a
week or if data has a non-weekly periodicity.}

\item{scale}{A \verb{<dist_spec>} specifying a prior on the scaling factor to be
applied to map latent infections (convolved to date of report).  Defaults
to a fixed value of 1, i.e. no scaling: \code{Fixed(1)}. A lower limit of zero
will be enforced automatically. If setting to a prior distribution and no
overreporting is expected, it might be sensible to set a maximum of 1 via
the \code{max} option when declaring the distribution.}

\item{na}{Deprecated; use the \code{\link[=fill_missing]{fill_missing()}} function instead}

\item{likelihood}{Logical, defaults to \code{TRUE}. Should the likelihood be
included in the model.}

\item{return_likelihood}{Logical, defaults to \code{FALSE}. Should the likelihood
be returned by the model.}

\item{phi}{deprecated; use \code{dispersion} instead}
}
\value{
An \verb{<obs_opts>} object of observation model settings.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Defines a list specifying the structure of the observation
model. Custom settings can be supplied which override the defaults.
}
\examples{
# default settings
obs_opts()

# Turn off day of the week effect
obs_opts(week_effect = TRUE)

# Scale reported data
obs_opts(scale = Normal(mean = 0.2, sd = 0.02))
}
