% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_seeding_time}
\alias{get_seeding_time}
\title{Estimate seeding time from delays and generation time}
\usage{
get_seeding_time(delays, generation_time, rt = rt_opts())
}
\arguments{
\item{delays}{A call to \code{\link[=delay_opts]{delay_opts()}} defining delay distributions and
options. See the documentation of \code{\link[=delay_opts]{delay_opts()}} and the examples below for
details.}

\item{generation_time}{A call to \code{\link[=gt_opts]{gt_opts()}} (or its alias
\code{\link[=generation_time_opts]{generation_time_opts()}}) defining the generation time distribution used.
For backwards compatibility a list of summary parameters can also be passed.}

\item{rt}{A list of options as generated by \code{\link[=rt_opts]{rt_opts()}} defining Rt
estimation. Defaults to \code{\link[=rt_opts]{rt_opts()}}. To generate new infections using
the non-mechanistic model instead of the renewal equation model, use
\code{rt = NULL}. The non-mechanistic model internally uses the setting
\code{rt = rt_opts(use_rt = FALSE, future = "project", gp_on = "R0")}.}
}
\value{
An integer seeding time
}
\description{
The seeding time is set to the mean of the specified delays, constrained
to be at least the maximum generation time
}
\keyword{internal}
