// Generated by rstantools.  Do not edit by hand.

/*
    EpiNow2 is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    EpiNow2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with EpiNow2.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_dist_fit_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 64> locations_array__ =
  {" (found before start of program)",
  " (in 'dist_fit', line 20, column 2 to column 42)",
  " (in 'dist_fit', line 21, column 2 to column 27)",
  " (in 'dist_fit', line 22, column 2 to column 41)",
  " (in 'dist_fit', line 23, column 2 to column 45)",
  " (in 'dist_fit', line 24, column 2 to column 44)",
  " (in 'dist_fit', line 27, column 2 to column 41)",
  " (in 'dist_fit', line 28, column 2 to column 40)",
  " (in 'dist_fit', line 30, column 4 to column 60)",
  " (in 'dist_fit', line 31, column 4 to column 57)",
  " (in 'dist_fit', line 29, column 17 to line 32, column 3)",
  " (in 'dist_fit', line 29, column 2 to line 32, column 3)",
  " (in 'dist_fit', line 41, column 4 to column 32)",
  " (in 'dist_fit', line 42, column 4 to column 31)",
  " (in 'dist_fit', line 40, column 24 to line 43, column 3)",
  " (in 'dist_fit', line 40, column 9 to line 43, column 3)",
  " (in 'dist_fit', line 38, column 4 to column 38)",
  " (in 'dist_fit', line 39, column 4 to column 45)",
  " (in 'dist_fit', line 39, column 41 to column 42)",
  " (in 'dist_fit', line 37, column 24 to line 40, column 3)",
  " (in 'dist_fit', line 37, column 9 to line 43, column 3)",
  " (in 'dist_fit', line 36, column 4 to column 73)",
  " (in 'dist_fit', line 35, column 17 to line 37, column 3)",
  " (in 'dist_fit', line 35, column 2 to line 43, column 3)",
  " (in 'dist_fit', line 56, column 6 to line 59, column 8)",
  " (in 'dist_fit', line 55, column 26 to line 60, column 5)",
  " (in 'dist_fit', line 55, column 11 to line 60, column 5)",
  " (in 'dist_fit', line 51, column 6 to line 54, column 8)",
  " (in 'dist_fit', line 50, column 26 to line 55, column 5)",
  " (in 'dist_fit', line 50, column 11 to line 60, column 5)",
  " (in 'dist_fit', line 46, column 6 to line 49, column 8)",
  " (in 'dist_fit', line 45, column 19 to line 50, column 5)",
  " (in 'dist_fit', line 45, column 4 to line 60, column 5)",
  " (in 'dist_fit', line 44, column 15 to line 61, column 3)",
  " (in 'dist_fit', line 44, column 2 to line 61, column 3)",
  " (in 'dist_fit', line 2, column 2 to column 11)",
  " (in 'dist_fit', line 3, column 2 to column 8)",
  " (in 'dist_fit', line 4, column 9 to column 10)",
  " (in 'dist_fit', line 4, column 2 to column 16)",
  " (in 'dist_fit', line 5, column 9 to column 10)",
  " (in 'dist_fit', line 5, column 2 to column 15)",
  " (in 'dist_fit', line 6, column 8 to column 17)",
  " (in 'dist_fit', line 6, column 2 to column 33)",
  " (in 'dist_fit', line 7, column 8 to column 16)",
  " (in 'dist_fit', line 7, column 2 to column 34)",
  " (in 'dist_fit', line 8, column 8 to column 16)",
  " (in 'dist_fit', line 8, column 2 to column 32)",
  " (in 'dist_fit', line 9, column 8 to column 17)",
  " (in 'dist_fit', line 9, column 2 to column 45)",
  " (in 'dist_fit', line 12, column 8 to column 17)",
  " (in 'dist_fit', line 12, column 2 to column 36)",
  " (in 'dist_fit', line 13, column 8 to column 17)",
  " (in 'dist_fit', line 13, column 2 to column 35)",
  " (in 'dist_fit', line 15, column 4 to column 53)",
  " (in 'dist_fit', line 16, column 4 to column 50)",
  " (in 'dist_fit', line 14, column 17 to line 17, column 3)",
  " (in 'dist_fit', line 14, column 2 to line 17, column 3)",
  " (in 'dist_fit', line 20, column 8 to column 17)",
  " (in 'dist_fit', line 21, column 8 to column 17)",
  " (in 'dist_fit', line 22, column 8 to column 17)",
  " (in 'dist_fit', line 23, column 8 to column 17)",
  " (in 'dist_fit', line 24, column 8 to column 17)",
  " (in 'dist_fit', line 27, column 8 to column 17)",
  " (in 'dist_fit', line 28, column 8 to column 17)"};
#include <stan_meta_header.hpp>
class model_dist_fit final : public model_base_crtp<model_dist_fit> {
private:
  int dist;
  int N;
  Eigen::Matrix<double,-1,1> low_data__;
  Eigen::Matrix<double,-1,1> up_data__;
  std::vector<double> lam_mean;
  std::vector<double> prior_mean;
  std::vector<double> prior_sd;
  std::vector<double> par_sigma;
  std::vector<double> prior_alpha;
  std::vector<double> prior_beta;
  int lambda_1dim__;
  int mu_1dim__;
  int sigma_1dim__;
  int alpha_raw_1dim__;
  int beta_raw_1dim__;
  int alpha_1dim__;
  int beta_1dim__;
  Eigen::Map<Eigen::Matrix<double,-1,1>> low{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> up{nullptr, 0};
public:
  ~model_dist_fit() {}
  model_dist_fit(stan::io::var_context& context__, unsigned int
                 random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_dist_fit_namespace::model_dist_fit";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 35;
      context__.validate_dims("data initialization", "dist", "int",
        std::vector<size_t>{});
      dist = std::numeric_limits<int>::min();
      current_statement__ = 35;
      dist = context__.vals_i("dist")[(1 - 1)];
      current_statement__ = 36;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 36;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 37;
      stan::math::validate_non_negative_index("low", "N", N);
      current_statement__ = 38;
      context__.validate_dims("data initialization", "low", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      low_data__ = Eigen::Matrix<double,-1,1>::Constant(N,
                     std::numeric_limits<double>::quiet_NaN());
      new (&low) Eigen::Map<Eigen::Matrix<double,-1,1>>(low_data__.data(), N);
      {
        std::vector<local_scalar_t__> low_flat__;
        current_statement__ = 38;
        low_flat__ = context__.vals_r("low");
        current_statement__ = 38;
        pos__ = 1;
        current_statement__ = 38;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 38;
          stan::model::assign(low, low_flat__[(pos__ - 1)],
            "assigning variable low", stan::model::index_uni(sym1__));
          current_statement__ = 38;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 39;
      stan::math::validate_non_negative_index("up", "N", N);
      current_statement__ = 40;
      context__.validate_dims("data initialization", "up", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      up_data__ = Eigen::Matrix<double,-1,1>::Constant(N,
                    std::numeric_limits<double>::quiet_NaN());
      new (&up) Eigen::Map<Eigen::Matrix<double,-1,1>>(up_data__.data(), N);
      {
        std::vector<local_scalar_t__> up_flat__;
        current_statement__ = 40;
        up_flat__ = context__.vals_r("up");
        current_statement__ = 40;
        pos__ = 1;
        current_statement__ = 40;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 40;
          stan::model::assign(up, up_flat__[(pos__ - 1)],
            "assigning variable up", stan::model::index_uni(sym1__));
          current_statement__ = 40;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 41;
      stan::math::validate_non_negative_index("lam_mean", "dist == 0",
        stan::math::logical_eq(dist, 0));
      current_statement__ = 42;
      context__.validate_dims("data initialization", "lam_mean", "double",
        std::vector<size_t>{static_cast<size_t>(
                              stan::math::logical_eq(dist, 0))});
      lam_mean = std::vector<double>(stan::math::logical_eq(dist, 0),
                   std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 42;
      lam_mean = context__.vals_r("lam_mean");
      current_statement__ = 43;
      stan::math::validate_non_negative_index("prior_mean", "dist > 0",
        stan::math::logical_gt(dist, 0));
      current_statement__ = 44;
      context__.validate_dims("data initialization", "prior_mean", "double",
        std::vector<size_t>{static_cast<size_t>(
                              stan::math::logical_gt(dist, 0))});
      prior_mean = std::vector<double>(stan::math::logical_gt(dist, 0),
                     std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 44;
      prior_mean = context__.vals_r("prior_mean");
      current_statement__ = 45;
      stan::math::validate_non_negative_index("prior_sd", "dist > 0",
        stan::math::logical_gt(dist, 0));
      current_statement__ = 46;
      context__.validate_dims("data initialization", "prior_sd", "double",
        std::vector<size_t>{static_cast<size_t>(
                              stan::math::logical_gt(dist, 0))});
      prior_sd = std::vector<double>(stan::math::logical_gt(dist, 0),
                   std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 46;
      prior_sd = context__.vals_r("prior_sd");
      current_statement__ = 47;
      stan::math::validate_non_negative_index("par_sigma", "dist == 2",
        stan::math::logical_eq(dist, 2));
      current_statement__ = 48;
      context__.validate_dims("data initialization", "par_sigma", "double",
        std::vector<size_t>{static_cast<size_t>(
                              stan::math::logical_eq(dist, 2))});
      par_sigma = std::vector<double>(stan::math::logical_eq(dist, 2),
                    std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 48;
      par_sigma = context__.vals_r("par_sigma");
      current_statement__ = 48;
      stan::math::check_greater_or_equal(function__, "par_sigma", par_sigma,
        0);
      current_statement__ = 49;
      stan::math::validate_non_negative_index("prior_alpha", "dist == 2",
        stan::math::logical_eq(dist, 2));
      current_statement__ = 50;
      prior_alpha = std::vector<double>(stan::math::logical_eq(dist, 2),
                      std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 51;
      stan::math::validate_non_negative_index("prior_beta", "dist == 2",
        stan::math::logical_eq(dist, 2));
      current_statement__ = 52;
      prior_beta = std::vector<double>(stan::math::logical_eq(dist, 2),
                     std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 56;
      if (stan::math::logical_eq(dist, 2)) {
        current_statement__ = 53;
        stan::model::assign(prior_alpha,
          stan::math::pow(
            (stan::model::rvalue(prior_mean, "prior_mean",
               stan::model::index_uni(1)) /
            stan::model::rvalue(prior_sd, "prior_sd",
              stan::model::index_uni(1))), 2),
          "assigning variable prior_alpha", stan::model::index_uni(1));
        current_statement__ = 54;
        stan::model::assign(prior_beta,
          (stan::model::rvalue(prior_mean, "prior_mean",
             stan::model::index_uni(1)) /
          stan::math::pow(
            stan::model::rvalue(prior_sd, "prior_sd",
              stan::model::index_uni(1)), 2)),
          "assigning variable prior_beta", stan::model::index_uni(1));
      }
      current_statement__ = 57;
      lambda_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 57;
      lambda_1dim__ = stan::math::logical_eq(dist, 0);
      current_statement__ = 57;
      stan::math::validate_non_negative_index("lambda", "dist == 0",
        lambda_1dim__);
      current_statement__ = 58;
      mu_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 58;
      mu_1dim__ = stan::math::logical_eq(dist, 1);
      current_statement__ = 58;
      stan::math::validate_non_negative_index("mu", "dist == 1", mu_1dim__);
      current_statement__ = 59;
      sigma_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 59;
      sigma_1dim__ = stan::math::logical_eq(dist, 1);
      current_statement__ = 59;
      stan::math::validate_non_negative_index("sigma", "dist == 1",
        sigma_1dim__);
      current_statement__ = 60;
      alpha_raw_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 60;
      alpha_raw_1dim__ = stan::math::logical_eq(dist, 2);
      current_statement__ = 60;
      stan::math::validate_non_negative_index("alpha_raw", "dist == 2",
        alpha_raw_1dim__);
      current_statement__ = 61;
      beta_raw_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 61;
      beta_raw_1dim__ = stan::math::logical_eq(dist, 2);
      current_statement__ = 61;
      stan::math::validate_non_negative_index("beta_raw", "dist == 2",
        beta_raw_1dim__);
      current_statement__ = 62;
      alpha_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 62;
      alpha_1dim__ = stan::math::logical_eq(dist, 2);
      current_statement__ = 62;
      stan::math::validate_non_negative_index("alpha", "dist == 2",
        alpha_1dim__);
      current_statement__ = 63;
      beta_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 63;
      beta_1dim__ = stan::math::logical_eq(dist, 2);
      current_statement__ = 63;
      stan::math::validate_non_negative_index("beta", "dist == 2",
        beta_1dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = lambda_1dim__ + mu_1dim__ + sigma_1dim__ +
      alpha_raw_1dim__ + beta_raw_1dim__;
  }
  inline std::string model_name() const final {
    return "model_dist_fit";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_dist_fit_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      std::vector<local_scalar_t__> lambda =
        std::vector<local_scalar_t__>(lambda_1dim__, DUMMY_VAR__);
      current_statement__ = 1;
      lambda = in__.template read_constrain_lb<std::vector<local_scalar_t__>,
                 jacobian__>(0, lp__, lambda_1dim__);
      std::vector<local_scalar_t__> mu =
        std::vector<local_scalar_t__>(mu_1dim__, DUMMY_VAR__);
      current_statement__ = 2;
      mu = in__.template read<std::vector<local_scalar_t__>>(mu_1dim__);
      std::vector<local_scalar_t__> sigma =
        std::vector<local_scalar_t__>(sigma_1dim__, DUMMY_VAR__);
      current_statement__ = 3;
      sigma = in__.template read_constrain_lb<std::vector<local_scalar_t__>,
                jacobian__>(0, lp__, sigma_1dim__);
      std::vector<local_scalar_t__> alpha_raw =
        std::vector<local_scalar_t__>(alpha_raw_1dim__, DUMMY_VAR__);
      current_statement__ = 4;
      alpha_raw = in__.template read_constrain_lb<
                    std::vector<local_scalar_t__>, jacobian__>(0, lp__,
                    alpha_raw_1dim__);
      std::vector<local_scalar_t__> beta_raw =
        std::vector<local_scalar_t__>(beta_raw_1dim__, DUMMY_VAR__);
      current_statement__ = 5;
      beta_raw = in__.template read_constrain_lb<
                   std::vector<local_scalar_t__>, jacobian__>(0, lp__,
                   beta_raw_1dim__);
      std::vector<local_scalar_t__> alpha =
        std::vector<local_scalar_t__>(alpha_1dim__, DUMMY_VAR__);
      std::vector<local_scalar_t__> beta =
        std::vector<local_scalar_t__>(beta_1dim__, DUMMY_VAR__);
      current_statement__ = 11;
      if (stan::math::logical_eq(dist, 2)) {
        current_statement__ = 8;
        stan::model::assign(alpha,
          (stan::model::rvalue(prior_alpha, "prior_alpha",
             stan::model::index_uni(1)) +
          (stan::model::rvalue(par_sigma, "par_sigma",
             stan::model::index_uni(1)) *
          stan::model::rvalue(alpha_raw, "alpha_raw",
            stan::model::index_uni(1)))), "assigning variable alpha",
          stan::model::index_uni(1));
        current_statement__ = 9;
        stan::model::assign(beta,
          (stan::model::rvalue(prior_beta, "prior_beta",
             stan::model::index_uni(1)) +
          (stan::model::rvalue(par_sigma, "par_sigma",
             stan::model::index_uni(1)) *
          stan::model::rvalue(beta_raw, "beta_raw", stan::model::index_uni(1)))),
          "assigning variable beta", stan::model::index_uni(1));
      }
      current_statement__ = 6;
      stan::math::check_greater_or_equal(function__, "alpha", alpha, 0);
      current_statement__ = 7;
      stan::math::check_greater_or_equal(function__, "beta", beta, 0);
      {
        current_statement__ = 23;
        if (stan::math::logical_eq(dist, 0)) {
          current_statement__ = 21;
          lp_accum__.add(stan::math::uniform_lpdf<propto__>(
                           stan::model::rvalue(lambda, "lambda",
                             stan::model::index_uni(1)), (1 / (5. *
                           stan::model::rvalue(lam_mean, "lam_mean",
                             stan::model::index_uni(1)))), (1 / (0.2 *
                           stan::model::rvalue(lam_mean, "lam_mean",
                             stan::model::index_uni(1))))));
        } else {
          current_statement__ = 20;
          if (stan::math::logical_eq(dist, 1)) {
            current_statement__ = 16;
            lp_accum__.add(stan::math::normal_lpdf<propto__>(
                             stan::model::rvalue(mu, "mu",
                               stan::model::index_uni(1)),
                             stan::model::rvalue(prior_mean, "prior_mean",
                               stan::model::index_uni(1)), 10));
            current_statement__ = 17;
            lp_accum__.add(stan::math::normal_lpdf<propto__>(
                             stan::model::rvalue(sigma, "sigma",
                               stan::model::index_uni(1)),
                             stan::model::rvalue(prior_sd, "prior_sd",
                               stan::model::index_uni(1)), 10));
            current_statement__ = 18;
            if (stan::math::logical_lt(
                  stan::model::rvalue(sigma, "sigma",
                    stan::model::index_uni(1)), 0)) {
              current_statement__ = 18;
              lp_accum__.add(stan::math::negative_infinity());
            } else {
              current_statement__ = 18;
              lp_accum__.add(-stan::math::normal_lccdf(0,
                                stan::model::rvalue(prior_sd, "prior_sd",
                                  stan::model::index_uni(1)), 10));
            }
          } else {
            current_statement__ = 15;
            if (stan::math::logical_eq(dist, 2)) {
              current_statement__ = 12;
              lp_accum__.add(stan::math::normal_lpdf<propto__>(
                               stan::model::rvalue(alpha_raw, "alpha_raw",
                                 stan::model::index_uni(1)), 0, 1));
              current_statement__ = 13;
              lp_accum__.add(stan::math::normal_lpdf<propto__>(
                               stan::model::rvalue(beta_raw, "beta_raw",
                                 stan::model::index_uni(1)), 0, 1));
            }
          }
        }
        current_statement__ = 34;
        for (int i = 1; i <= N; ++i) {
          current_statement__ = 32;
          if (stan::math::logical_eq(dist, 0)) {
            current_statement__ = 30;
            lp_accum__.add(stan::math::log_diff_exp(
                             stan::math::exponential_lcdf(
                               stan::model::rvalue(up, "up",
                                 stan::model::index_uni(i)), lambda),
                             stan::math::exponential_lcdf(
                               stan::model::rvalue(low, "low",
                                 stan::model::index_uni(i)), lambda)));
          } else {
            current_statement__ = 29;
            if (stan::math::logical_eq(dist, 1)) {
              current_statement__ = 27;
              lp_accum__.add(stan::math::log_diff_exp(
                               stan::math::lognormal_lcdf(
                                 stan::model::rvalue(up, "up",
                                   stan::model::index_uni(i)), mu, sigma),
                               stan::math::lognormal_lcdf(
                                 stan::model::rvalue(low, "low",
                                   stan::model::index_uni(i)), mu, sigma)));
            } else {
              current_statement__ = 26;
              if (stan::math::logical_eq(dist, 2)) {
                current_statement__ = 24;
                lp_accum__.add(stan::math::log_diff_exp(
                                 stan::math::gamma_lcdf(
                                   stan::model::rvalue(up, "up",
                                     stan::model::index_uni(i)), alpha, beta),
                                 stan::math::gamma_lcdf(
                                   stan::model::rvalue(low, "low",
                                     stan::model::index_uni(i)), alpha, beta)));
              }
            }
          }
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_dist_fit_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      std::vector<double> lambda =
        std::vector<double>(lambda_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      lambda = in__.template read_constrain_lb<std::vector<local_scalar_t__>,
                 jacobian__>(0, lp__, lambda_1dim__);
      std::vector<double> mu =
        std::vector<double>(mu_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      mu = in__.template read<std::vector<local_scalar_t__>>(mu_1dim__);
      std::vector<double> sigma =
        std::vector<double>(sigma_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 3;
      sigma = in__.template read_constrain_lb<std::vector<local_scalar_t__>,
                jacobian__>(0, lp__, sigma_1dim__);
      std::vector<double> alpha_raw =
        std::vector<double>(alpha_raw_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 4;
      alpha_raw = in__.template read_constrain_lb<
                    std::vector<local_scalar_t__>, jacobian__>(0, lp__,
                    alpha_raw_1dim__);
      std::vector<double> beta_raw =
        std::vector<double>(beta_raw_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 5;
      beta_raw = in__.template read_constrain_lb<
                   std::vector<local_scalar_t__>, jacobian__>(0, lp__,
                   beta_raw_1dim__);
      std::vector<double> alpha =
        std::vector<double>(alpha_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      std::vector<double> beta =
        std::vector<double>(beta_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(lambda);
      out__.write(mu);
      out__.write(sigma);
      out__.write(alpha_raw);
      out__.write(beta_raw);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 11;
      if (stan::math::logical_eq(dist, 2)) {
        current_statement__ = 8;
        stan::model::assign(alpha,
          (stan::model::rvalue(prior_alpha, "prior_alpha",
             stan::model::index_uni(1)) +
          (stan::model::rvalue(par_sigma, "par_sigma",
             stan::model::index_uni(1)) *
          stan::model::rvalue(alpha_raw, "alpha_raw",
            stan::model::index_uni(1)))), "assigning variable alpha",
          stan::model::index_uni(1));
        current_statement__ = 9;
        stan::model::assign(beta,
          (stan::model::rvalue(prior_beta, "prior_beta",
             stan::model::index_uni(1)) +
          (stan::model::rvalue(par_sigma, "par_sigma",
             stan::model::index_uni(1)) *
          stan::model::rvalue(beta_raw, "beta_raw", stan::model::index_uni(1)))),
          "assigning variable beta", stan::model::index_uni(1));
      }
      current_statement__ = 6;
      stan::math::check_greater_or_equal(function__, "alpha", alpha, 0);
      current_statement__ = 7;
      stan::math::check_greater_or_equal(function__, "beta", beta, 0);
      if (emit_transformed_parameters__) {
        out__.write(alpha);
        out__.write(beta);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      std::vector<local_scalar_t__> lambda =
        std::vector<local_scalar_t__>(lambda_1dim__, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(lambda,
        in__.read<std::vector<local_scalar_t__>>(lambda_1dim__),
        "assigning variable lambda");
      out__.write_free_lb(0, lambda);
      std::vector<local_scalar_t__> mu =
        std::vector<local_scalar_t__>(mu_1dim__, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(mu,
        in__.read<std::vector<local_scalar_t__>>(mu_1dim__),
        "assigning variable mu");
      out__.write(mu);
      std::vector<local_scalar_t__> sigma =
        std::vector<local_scalar_t__>(sigma_1dim__, DUMMY_VAR__);
      current_statement__ = 3;
      stan::model::assign(sigma,
        in__.read<std::vector<local_scalar_t__>>(sigma_1dim__),
        "assigning variable sigma");
      out__.write_free_lb(0, sigma);
      std::vector<local_scalar_t__> alpha_raw =
        std::vector<local_scalar_t__>(alpha_raw_1dim__, DUMMY_VAR__);
      current_statement__ = 4;
      stan::model::assign(alpha_raw,
        in__.read<std::vector<local_scalar_t__>>(alpha_raw_1dim__),
        "assigning variable alpha_raw");
      out__.write_free_lb(0, alpha_raw);
      std::vector<local_scalar_t__> beta_raw =
        std::vector<local_scalar_t__>(beta_raw_1dim__, DUMMY_VAR__);
      current_statement__ = 5;
      stan::model::assign(beta_raw,
        in__.read<std::vector<local_scalar_t__>>(beta_raw_1dim__),
        "assigning variable beta_raw");
      out__.write_free_lb(0, beta_raw);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "lambda", "double",
        std::vector<size_t>{static_cast<size_t>(lambda_1dim__)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "mu", "double",
        std::vector<size_t>{static_cast<size_t>(mu_1dim__)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "sigma", "double",
        std::vector<size_t>{static_cast<size_t>(sigma_1dim__)});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "alpha_raw",
        "double", std::vector<size_t>{static_cast<size_t>(alpha_raw_1dim__)});
      current_statement__ = 5;
      context__.validate_dims("parameter initialization", "beta_raw",
        "double", std::vector<size_t>{static_cast<size_t>(beta_raw_1dim__)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      std::vector<local_scalar_t__> lambda =
        std::vector<local_scalar_t__>(lambda_1dim__, DUMMY_VAR__);
      current_statement__ = 1;
      lambda = context__.vals_r("lambda");
      out__.write_free_lb(0, lambda);
      std::vector<local_scalar_t__> mu =
        std::vector<local_scalar_t__>(mu_1dim__, DUMMY_VAR__);
      current_statement__ = 2;
      mu = context__.vals_r("mu");
      out__.write(mu);
      std::vector<local_scalar_t__> sigma =
        std::vector<local_scalar_t__>(sigma_1dim__, DUMMY_VAR__);
      current_statement__ = 3;
      sigma = context__.vals_r("sigma");
      out__.write_free_lb(0, sigma);
      std::vector<local_scalar_t__> alpha_raw =
        std::vector<local_scalar_t__>(alpha_raw_1dim__, DUMMY_VAR__);
      current_statement__ = 4;
      alpha_raw = context__.vals_r("alpha_raw");
      out__.write_free_lb(0, alpha_raw);
      std::vector<local_scalar_t__> beta_raw =
        std::vector<local_scalar_t__>(beta_raw_1dim__, DUMMY_VAR__);
      current_statement__ = 5;
      beta_raw = context__.vals_r("beta_raw");
      out__.write_free_lb(0, beta_raw);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"lambda", "mu", "sigma", "alpha_raw",
                "beta_raw"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"alpha", "beta"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    lambda_1dim__)},
                std::vector<size_t>{static_cast<size_t>(mu_1dim__)},
                std::vector<size_t>{static_cast<size_t>(sigma_1dim__)},
                std::vector<size_t>{static_cast<size_t>(alpha_raw_1dim__)},
                std::vector<size_t>{static_cast<size_t>(beta_raw_1dim__)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(alpha_1dim__)},
             std::vector<size_t>{static_cast<size_t>(beta_1dim__)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "lambda" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "mu" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigma" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= alpha_raw_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "alpha_raw" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= beta_raw_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta_raw" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "alpha" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "beta" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "lambda" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "mu" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigma" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= alpha_raw_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "alpha_raw" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= beta_raw_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta_raw" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "alpha" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "beta" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {}
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"lambda\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(lambda_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(mu_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(sigma_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"alpha_raw\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(alpha_raw_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(beta_raw_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(alpha_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(beta_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"lambda\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(lambda_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(mu_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(sigma_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"alpha_raw\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(alpha_raw_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(beta_raw_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(alpha_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(beta_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((lambda_1dim__ + mu_1dim__) +
      sigma_1dim__) + alpha_raw_1dim__) + beta_raw_1dim__);
    const size_t num_transformed = emit_transformed_parameters *
      ((alpha_1dim__ + beta_1dim__));
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((lambda_1dim__ + mu_1dim__) +
      sigma_1dim__) + alpha_raw_1dim__) + beta_raw_1dim__);
    const size_t num_transformed = emit_transformed_parameters *
      ((alpha_1dim__ + beta_1dim__));
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_dist_fit_namespace::model_dist_fit;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_dist_fit_namespace::profiles__;
}
#endif
#endif
