% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{gamma_dist_def}
\alias{gamma_dist_def}
\title{Generate a Gamma Distribution Definition Based on Parameter Estimates}
\usage{
gamma_dist_def(
  shape,
  shape_sd,
  scale,
  scale_sd,
  mean,
  mean_sd,
  sd,
  sd_sd,
  max_value,
  samples
)
}
\arguments{
\item{shape}{Numeric, shape parameter of the gamma distribution.}

\item{shape_sd}{Numeric, standard deviation of the shape parameter.}

\item{scale}{Numeric, scale parameter of the gamma distribution.}

\item{scale_sd}{Numeric, standard deviation of the scale parameter.}

\item{mean}{Numeric, log mean parameter of the gamma distribution.}

\item{mean_sd}{Numeric, standard deviation of the log mean parameter.}

\item{sd}{Numeric, log sd parameter of the gamma distribution.}

\item{sd_sd}{Numeric, standard deviation of the log sd parameter.}

\item{max_value}{Numeric, the maximum value to allow. Defaults to 120. Samples outside
of this range are resampled.}

\item{samples}{Numeric, number of sample distributions to generate.}
}
\value{
A data.table defining the distribution as used by \code{dist_skel}
}
\description{
Generates a distribution definition when only parameter estimates
are available for gamma distributed parameters. See \code{rgamma} for distribution information.
}
\examples{
# using estimated shape and scale
def <- gamma_dist_def(shape = 5.807, shape_sd = 0.2,
               scale = 0.9, scale_sd = 0.05,
               max_value = 20, samples = 10)
print(def)
def$params[[1]]

# using mean and sd
def <- gamma_dist_def(mean = 3, mean_sd = 0.5,
               sd = 3, sd_sd = 0.1,
               max_value = 20, samples = 10)
print(def)
def$params[[1]]
}
