% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.icm}
\alias{plot.icm}
\title{Plot Data from a Stochastic Individual Contact Epidemic Model}
\usage{
\method{plot}{icm}(
  x,
  y,
  popfrac = FALSE,
  sim.lines = FALSE,
  sims,
  sim.col,
  sim.lwd,
  sim.alpha,
  mean.line = TRUE,
  mean.smooth = TRUE,
  mean.col,
  mean.lwd = 2,
  mean.lty = 1,
  qnts = 0.5,
  qnts.col,
  qnts.alpha,
  qnts.smooth = TRUE,
  legend,
  leg.cex = 0.8,
  axs = "r",
  grid = FALSE,
  add = FALSE,
  ...
)
}
\arguments{
\item{x}{An \code{EpiModel} model object of class \code{netsim}.}

\item{y}{Output compartments or flows from \code{netsim} object to plot.}

\item{popfrac}{If \code{TRUE}, plot prevalence of values rather than numbers
(see details).}

\item{sim.lines}{If \code{TRUE}, plot individual simulation lines. Default is
to plot lines for one-group models but not for two-group models.}

\item{sims}{If \code{type="epi"} or \code{"formation"}, a vector of
simulation numbers to plot. If \code{type="network"}, a single
simulation number for network plot, or else \code{"min"} to plot the
simulation number with the lowest disease prevalence, \code{"max"} for
the simulation with the highest disease prevalence, or \code{"mean"}
for the simulation with the prevalence closest to the mean across
simulations at the specified time step.}

\item{sim.col}{Vector of any standard R color format for simulation lines.}

\item{sim.lwd}{Line width for simulation lines.}

\item{sim.alpha}{Transparency level for simulation lines, where
0 = transparent and 1 = opaque (see \code{adjustcolor} function).}

\item{mean.line}{If \code{TRUE}, plot mean of simulations across time.}

\item{mean.smooth}{If \code{TRUE}, use a loess smoother on the mean line.}

\item{mean.col}{Vector of any standard R color format for mean lines.}

\item{mean.lwd}{Line width for mean lines.}

\item{mean.lty}{Line type for mean lines.}

\item{qnts}{If numeric, plot polygon of simulation quantiles based on the
range implied by the argument (see details). If \code{FALSE}, suppress
polygon from plot.}

\item{qnts.col}{Vector of any standard R color format for polygons.}

\item{qnts.alpha}{Transparency level for quantile polygons, where 0 =
transparent and 1 = opaque (see \code{adjustcolor} function).}

\item{qnts.smooth}{If \code{TRUE}, use a loess smoother on quantile polygons.}

\item{legend}{If \code{TRUE}, plot default legend.}

\item{leg.cex}{Legend scale size.}

\item{axs}{Plot axis type (see \code{\link{par}} for details), with default
to \code{"r"}.}

\item{grid}{If \code{TRUE}, a grid is added to the background of plot
(see \code{\link{grid}} for details), with default of nx by ny.}

\item{add}{If \code{TRUE}, new plot window is not called and lines are added
to existing plot window.}

\item{...}{additional arguments to pass.}
}
\description{
Plots epidemiological data from a stochastic individual contact
             model simulated with \code{icm}.
}
\examples{
## Example 1: Plotting multiple compartment values from SIR model
param <- param.icm(inf.prob = 0.5, act.rate = 0.5, rec.rate = 0.02)
init <- init.icm(s.num = 500, i.num = 1, r.num = 0)
control <- control.icm(type = "SIR", nsteps = 100,
                       nsims = 3, verbose = FALSE)
mod <- icm(param, init, control)
plot(mod, grid = TRUE)

## Example 2: Plot only infected with specific output from SI model
param <- param.icm(inf.prob = 0.25, act.rate = 0.25)
init <- init.icm(s.num = 500, i.num = 10)
control <- control.icm(type = "SI", nsteps = 100,
                       nsims = 3, verbose = FALSE)
mod2 <- icm(param, init, control)

# Plot prevalence
plot(mod2, y = "i.num", mean.line = FALSE, sim.lines = TRUE)

# Plot incidence
par(mfrow = c(1, 2))
plot(mod2, y = "si.flow", mean.smooth = TRUE, grid = TRUE)
plot(mod2, y = "si.flow", qnts.smooth = FALSE, qnts = 1)

}
\seealso{
\code{\link{icm}}
}
\keyword{plot}
