% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som.R
\name{SOM}
\alias{SOM}
\title{Build a self-organizing map}
\usage{
SOM(data, xdim = 10, ydim = 10, zdim = NULL, rlen = 10,
  alphaA = c(0.05, 0.01), radiusA = stats::quantile(nhbrdist, 0.67) *
  c(1, 0), alphaB = alphaA * c(-negAlpha, -0.01 * negAlpha),
  radiusB = negRadius * radiusA, init = FALSE,
  initf = Initialize_PCA, distf = 2, codes = NULL,
  importance = NULL, nhbr.method = "maximum", negRadius = 1.33,
  negAlpha = 0.1, noMapping = F)
}
\arguments{
\item{data}{Matrix containing the training data}

\item{xdim}{Width of the grid}

\item{ydim}{Hight of the grid}

\item{zdim}{Depth of the grid, causes grid to be 3D}

\item{rlen}{Number of times to loop over the training data for each MST}

\item{alphaA}{Start and end learning rate}

\item{radiusA}{Start and end radius}

\item{alphaB}{Start and end learning rate for the second radius}

\item{radiusB}{Start and end radius (make sure it's larger than radiusA)}

\item{init}{Initialize cluster centers in a non-random way}

\item{initf}{Use the given initialization function if init==T
(default: Initialize_PCA)}

\item{distf}{Distance function (1=manhattan, 2=euclidean, 3=chebyshev)}

\item{codes}{Cluster centers to start with}

\item{importance}{array with numeric values. Parameters will be scaled
according to importance}

\item{nhbr.method}{Way of computing grid distances, passed as method= to dist() function. Default 'maximum' (square neighborhoods); use 'euclidean' for round neighborhoods.}

\item{negRadius}{easy way to set radiusB as a multiple of default radius
(use lower value for higher dimensions)}

\item{negAlpha}{the same for alphaB}

\item{noMapping}{If true, do not produce mapping (default F). Useful for online/streaming use.}
}
\value{
A map, which is a list containing all parameter settings and results
}
\description{
Build a self-organizing map
}
\seealso{
FlowSOM::SOM
}
