% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmapplot.R
\name{heatmapplot}
\alias{heatmapplot}
\title{heatmap}
\usage{
heatmapplot(formula, data, xbreaks = NULL, ybreaks = NULL,
  addvals = FALSE, addN = FALSE, digits = 1, ...)
}
\arguments{
\item{formula}{formula for plot}

\item{data}{data set for plot (typically a data frame)}

\item{xbreaks}{numeric, the breakpoints for the horizontal axis}

\item{ybreaks}{numeric, the breakpoints for the vertical axis}

\item{addvals}{add the response values to the plot}

\item{addN}{add the sample size to the plot}

\item{digits}{numeric: if response variable is plotted, round to this many digits (default is 1)}

\item{...}{other parameters passed on to plot() or text()}
}
\value{
a plot
}
\description{
heatmap
}
\examples{
xdata <- expand.grid(a = seq(0, 1, 0.1), b = seq(10, 20, 1))
xdata$resp <- rnorm(nrow(xdata))
heatmapplot(resp ~ a + b, data = xdata)

set.seed(123)
xdata <- expand.grid(k = seq(8, 200, length.out = 31), shape = seq(0, 1, length.out = 31))
idata <- randomsequence(10, 50, reversals = 0.3)
allids <- colnames(idata$pres)[2:ncol(idata$pres)]
winner <- as.character(idata$seqdat$winner)
loser <- as.character(idata$seqdat$loser)

myranks <- 1:length(allids)
names(myranks) <- allids

for(i in 1:nrow(xdata)) {
  kv <- rep(xdata$k[i], length(winner))
  sv <- createstartvalues(ranks = myranks, shape = xdata$shape[i])$res
  res <- fastelo(WINNER = winner, LOSER = loser, ALLIDS = allids, KVALS = kv, STARTVALUES = sv,
                 ROUND = FALSE)
  xdata$ll[i] <- likelo(res)
}

heatmapplot(ll ~ k + shape, data = xdata)
}
