% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{package}
\name{ElectionsLATAM}
\alias{ElectionsLATAM}
\alias{.onLoad}
\title{ElectionsLATAM}
\usage{
.onLoad(libname, pkgname)
}
\arguments{
\item{libname}{Library name}

\item{pkgname}{Package name}
}
\description{
A package to work with SQL datasources in a simple manner
}
\examples{
library(ElectionsLATAM)
library(readr)
costa.rica.ein.path <- file.path(getPackageDir(), "costa-rica")
ecological.inference.calvo <- EcologicalInferenceStrategyCalvoEtAl$new()
costa.rica.ein <-
  EcologicalInferenceProcessor$new(
    ecological.inference.strategy = ecological.inference.calvo,
    election.name = "2022-costa-rica-general-ballotage-n4",
    scenario = "final",
    data.input.path = costa.rica.ein.path,
    input.file = "2021-generales_pivot_candidatos_n4.csv",
    location.fields = c("id_unidad"),
    votes.field = "votos",
    # potential.votes.field = "habilitados",
    ignore.fields = "habilitados",
    col.types = cols(
      .default = col_number(),
      id_unidad = col_character()
    )
  )
dummy <- costa.rica.ein$loadInputPivotCandidatos()
costa.rica.ein$output.election <- readr::read_delim(
  file.path(
    costa.rica.ein.path,
    paste("2022-ballotage_pivot_candidatos_n4.csv", sep = "_")
  ),
  delim = ";",
  col_types = cols(
    .default = col_double(),
    id_unidad = col_character()
  )
)
costa.rica.ein$runScenario(include.blancos = TRUE, include.ausentes = TRUE)

}
\author{
Alejandro Baranek <abaranek@dc.uba.ar>
}
