% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EigenR.R
\name{Eigen_cos}
\alias{Eigen_cos}
\title{Matrix cosine}
\usage{
Eigen_cos(M)
}
\arguments{
\item{M}{a square matrix, real or complex}
}
\value{
The matrix cosine of \code{M}.
}
\description{
Matrix cosine of a real or complex square matrix.
}
\examples{
library(EigenR)
M <- toeplitz(c(1,2,3))
cosM <- Eigen_cos(M) 
sinM <- Eigen_sin(M)
cosM \%*\% cosM + sinM \%*\% sinM # identity matrix
}
