% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.sdf.R
\name{merge.edsurvey.data}
\alias{merge.edsurvey.data}
\alias{merge.edsurvey.data.frame}
\title{EdSurvey Merge}
\usage{
\method{merge}{edsurvey.data.frame}(x, y, by = "id", by.x = by, by.y = by, ...)
}
\arguments{
\item{x}{a \code{edsurvey.data.frame}. The \code{x} object is retained and has y values stored in the internal cache in memory.
\code{x} also supports \code{light.edusrvey.data.frame} objects if \code{y} is a \code{data.frame} or \code{light.edsurvey.data.frame} object.}

\item{y}{either a \code{light.edsurvey.data.frame} or a \code{data.frame}}

\item{by}{the column name(s) to perform the data merge operation.  If differing column names between the \code{x} and \code{y} objects, use the \code{by.x} and \code{by.y} arguments.}

\item{by.x}{the column name(s) to perform the data merge operation for the \code{x} object.  Defaults to \code{by} value.}

\item{by.y}{the column name(s) to perform the data merge operation for the \code{y} object.  Defaults to \code{by} value.}

\item{\dots}{arguments passed to merge, note that \code{all.x} will always be \code{TRUE} (the data on the \code{edsurvey.data.frame} will always be kept) and \code{all.y} will always be \code{FALSE} to avoid adding data not on the \code{edsurvey.data.frame}.}
}
\value{
a merged data set the same object type as \code{x}. For \code{edsurvey.data.frame} objects then resulting merged data is stored in the objects internal data cache.
}
\description{
Takes a \code{data.frame} or a \code{light.edsurvey.data.frame} and merges with a \code{edsurvey.data.frame} into it's internal data cache.
}
\examples{
\dontrun{
# read in NAEP primer data
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))
lsdf <- getData(data=sdf, varnames=c("dsex", "b017451"), addAttributes = TRUE)
df <- data.frame(dsex = c("Male","Female"), dsex2 = c("Boy","Girl"))

#merging an edsurvey.data.frame with a data.frame/light.edsurvey.data.frame
#returns an edsurvey.data.frame object
sdf2 <- merge(sdf, df, by = "dsex")
table(sdf2$dsex2)

# merging a light.edsurvey.data.frame with a data.frame
# returns a light.edsurvey.data.frame object
merged_lsdf <- merge(lsdf,df, by = "dsex")
class(merged_lsdf) #  "light.edsurvey.data.frame" "data.frame"
head(merged_lsdf) # shows merge results

# merging behaves similarly to base::merge
df2 <- data.frame(dsex = c("Male","Female"), b017451 = c(1,2))
merged_lsdf2 <- merge(lsdf,df2, by = "dsex")
names(merged_lsdf2) # "dsex"      "b017451.x" "b017451.y"
head(merged_lsdf2) # shows merge results
}
}
\seealso{
\ifelse{latex}{\code{merge}}{\code{\link[base]{merge}}}
}
\author{
Tom Fink
}
