% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hasPlausibleValue.R
\name{hasPlausibleValue}
\alias{hasPlausibleValue}
\title{Return a value indicating whether this variable has associated plausible values.}
\usage{
hasPlausibleValue(var, sdf)
}
\arguments{
\item{var}{character indicating the variable in question.}

\item{sdf}{an \code{edsurvey.data.frame} or a \code{light.edsurvey.data.frame}.}
}
\value{
A boolean (or vector when \code{var} is a vector) indicating if each element of \code{var} has
        plausible values associated with it.
}
\description{
Return a value indicating if this variable has associated plausible values in an \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame}.
}
\details{
Note that this function returns \code{TRUE} only when the variable passed to it is the name for a set of plausible values, but
         not if it is an individual plausible value from such a set. Thus, on the NAEP primer, \code{composite} has plausible
         values (and so \code{TRUE} would be returned by this function), but any of the plausible values or variable names defined on
         the actual data (such as \code{"mrpcm1"} or \code{"dsex"}) are not.
}
\examples{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))

# True
hasPlausibleValue("composite", sdf)

# False
hasPlausibleValue("dsex", sdf)
}
\author{
Michael Lee and Paul Bailey
}
