% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotEcotone.R
\name{plotEco}
\alias{plotEco}
\title{Plotting component for EcotoneFinder}
\usage{
plotEco(ecotonefinder, plot.data = FALSE, plot.method = c("none",
  "dca", "fanny", "vegclust", "cmeans", "diversity"), axis.number = 1,
  magnification = 20, magnification.diversity = 5,
  col.data = "black", col.method = c("red", "blue"), title = NULL,
  ylab = "Species", xlab = "Gradient", na.rm = FALSE, alone = TRUE,
  ...)
}
\arguments{
\item{ecotonefinder}{A list containing elements named in the same way than
EcotoneFinder function outcomes}

\item{plot.data}{Logical. Should the data be plotted.}

\item{plot.method}{Analysis method to be plotted from the EcotoneFinder
analyses. Must be one or several of "none","dca","fanny","vegclust",
"cmeans" or"diversity".}

\item{axis.number}{Number of axis to plot from the DCA.}

\item{magnification}{Magnification coefficient for the method. Usefull if the
data are being plotted.}

\item{magnification.diversity}{Particular magnification for the diversity
indices.}

\item{col.data}{Colors to be used for the data. See CommunityColor function.}

\item{col.method}{Colors to be used for the methods.}

\item{title}{An overall title for the plot. See plot.}

\item{ylab}{A title for the y-axis. See plot.}

\item{xlab}{A title for the x-axis. See plot.}

\item{na.rm}{Logical. Should NAs be removed.}

\item{alone}{Logical. If FALSE, lines are added to an existing plot.}

\item{...}{Additional argument to be passed to the plot function.}
}
\value{
A plot with the EcotoneFinder results along the gradient, and
  optionally, the data.
}
\description{
Plotting component for EcotoneFinder
}
\details{
Internal component of the PlotEcotone function for the plotting of
  the EcotoneFinder analyses. Use PlotEcotone directly for more options.
}
\examples{
 ######## Artificial dataset & analysis:
 SyntheticTrial <- SyntheticData(SpeciesNum = 20, CommunityNum = 3,
                                 SpCo = NULL, Length = 500,
                                 Parameters = list(a=rep(60, 3),
                                                   b=c(0,250,500),
                                                   c=rep(0.03,3)),
                                 dev.c = .015, pal = c("#008585", "#FBF2C4", "#C7522B"))

 SyntheticEcoFinder <- EcotoneFinder(SyntheticTrial[,-1],
                                     dist = SyntheticTrial$Distance,
                                     method = "all", groups = 3,
                                     standardize = "hellinger",
                                     diversity = "all")

 ### Plot:
 require(colorspace)
 plotEco(SyntheticEcoFinder, plot.data = FALSE,
         plot.method = c("cmeans", "dca"),
         axis.number = 2, col.method = terrain_hcl(3))

}
