% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.plotCorrelog.R
\name{eco.plotCorrelogB}
\alias{eco.plotCorrelogB}
\title{eco.plotCorrelogB}
\usage{
eco.plotCorrelogB(x, var = NULL, xlabel = NULL, ylabel = NULL,
  title = NULL, legend = TRUE, background = c("grey", "white"),
  significant.S = TRUE, xlim = NULL, ylim = NULL,
  interactivePlot = TRUE)
}
\arguments{
\item{x}{Result of correlogram  analysis, with output using angles as independent 
variables for fixed distances (instead of distances as independent variables)}

\item{var}{Individual variable to plot; var is a number between 1 and the number of 
distance classes indicating the corresponding class (for example, with 5 distance classes,
the number 3 indicates the third)
To plot multiple variables in a same plot, use only the argument x (see examples)}

\item{xlabel}{Label for X axis (default: NULL)}

\item{ylabel}{Label for Y axis (default: NULL)}

\item{title}{Title of the plot (default: NULL)}

\item{legend}{Show legends in ggplot graphs? (default: TRUE)}

\item{background}{background color ("grey" or "white")}

\item{significant.S}{With single variables and permutation test: 
show different colours for significant points? (default: TRUE)}

\item{xlim}{X axis limits (as vector: c(min, max);  default: NULL)}

\item{ylim}{Y axis limits (as vector: c(min, max);  default: NULL)}

\item{interactivePlot}{Show an interactive plot via plotly? (default: TRUE)}
}
\description{
Plot method for bearing correlograms
For examples see  \code{\link{eco.correlog}}. It constructs an angular correlogram
for each distance class taken as fixed.
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}
\seealso{
\code{\link{eco.correlog}}
}

