% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/eco.2genepop.R
\name{eco.2genepop}
\alias{eco.2genepop}
\title{Exporting an ecogen genetic data frame into Genepop format}
\usage{
eco.2genepop(eco, name = "infile.genepop.txt", grp = NULL, nout = 3,
  sep = "")
}
\arguments{
\item{eco}{Object of class "ecogen".}

\item{name}{The name of the output file.}

\item{grp}{The name of the S slot column with groups in which the sample
must be divided (e.g., populations). If groups are not given (grp = NULL),
all individuals will be assigned to a single one.}

\item{nout}{Number of digits in the output file}

\item{sep}{Character separating alleles.}
}
\value{
A Genepop file in the working directory.
}
\description{
This function converts the genetic
data of an ecogen object into a Genepop input file.
}
\examples{
\dontrun{

data(eco.test)
eco.2genepop(eco, grp = "pop", name = "infile.genepop.txt")
# an output file "infile.genepop.txt" is generated in the working directory

}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

