% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.theilsen.R
\name{eco.theilsen}
\alias{eco.theilsen}
\title{Theil-sen regression for a raster time series}
\usage{
eco.theilsen(stacked, date, adjust = c("none", "holm", "hochberg", "hommel",
  "bonferroni", "BH", "BY", "fdr"))
}
\arguments{
\item{stacked}{Stacked images ("RasterLayer"  or "RasterBrick").}

\item{date}{Vector with dates for each image.}

\item{adjust}{Adjustment method passed to \code{\link[stats]{p.adjust}}.
Default "none".}
}
\description{
This function computes the theil-sen estimator and
the p-value associated for each pixel over time in a stack of images,
writing the values in a raster (one for the estimators and one for
the p-values). It is recommended to use a "RasterBrick", that
is more efficient in managing memory.
}
\examples{
\dontrun{

require("raster")
require("animation")
temp <- list()

for(i in 1:100) {
temp[[i]] <- runif(36,-1, 1)
temp[[i]] <- matrix(temp[[i]], 6, 6)
temp[[i]] <- raster(temp[[i]])
}

temp <- brick(temp)

oopt <- ani.options(interval = 0.01)
for (i in 1:ani.options("nmax")) {
plot(temp[[i]])
ani.pause()
}
ani.options(oopt)

writeRaster(temp,"temporal.tif", overwrite=T)
rm(temp)
ndvisim <- brick("temporal.tif")

date <- seq(from = 1990.1, length.out = 100, by = 0.2)

eco.theilsen(ndvisim, date)

pvalue <- raster("pvalue.tif")
slope <- raster("slope.tif")
par(mfrow = c(1, 2))
plot(pvalue, main = "p-value")
plot(slope, main = "slope")

}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}
\seealso{
\code{\link[rkt]{rkt}}.
}

