% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prior_sampling.R
\name{sample_prior}
\alias{sample_prior}
\title{Generate samples of latent variables from prior predictive distribution}
\usage{
sample_prior(
  observations,
  simulators,
  priors,
  sam_priors,
  num_samples = 1,
  full_sample = TRUE,
  ...
)
}
\arguments{
\item{observations}{A \code{list} of length 2 containing observations and a covariance matrix. The first element is a \code{data.frame} or \code{matrix} with each column giving observations of each output of interest and each row a time. Rows should be named with the times and columns should be named the variables. The second element is is a \eqn{d \times d} \code{matrix} where \eqn{d} is the number of columns of the observations data frame / matrix. This matrix is the covariance matrix of the observations.}

\item{simulators}{A \code{list} with length equal to the number of simulators. For each simulator, there is a \code{list} of 2 objects containing the simulator output and covariance matrix. The first element is a \code{data.frame} or \code{matrix} with each column giving a simulator outputs of interest and each row a time. Rows should be named with the times and columns should be named the variables. The second element is a \eqn{n_k \times n_k} \code{matrix} where \eqn{n_k} is the number of columns of the simulators output data frame / matrix. This matrix is the covariance matrix of the simulator outputs.}

\item{priors}{An \code{EnsemblePrior} object specifying the prior distributions for the ensemble.}

\item{sam_priors}{A \code{list} containing two items named \code{samples} and \code{point_estimate}. \code{samples} is either a \code{NULL} or a \code{stanfit} object containing the samples drawn from the prior distribution of the ensemble model and \code{point_estimate} is either a \code{NULL} or a \code{list} object containing the optimised prior distribution of the ensemble model. If this object is \code{missing} then \code{sample_prior} generates it.}

\item{num_samples}{A \code{numeric} specifying the number of samples to be generated. The default is 1.}

\item{full_sample}{A \code{logical} that runs a full sampling of the prior density of the ensemble model if \code{TRUE}. If \code{FALSE}, returns the point estimate which maximises the prior density of the ensemble model.}

\item{...}{Additional arguments passed to the function \code{rstan::sampling} or  \code{rstan::optimizing}.}
}
\value{
An \code{EnsembleSample} object.
}
\description{
Methods to generates samples of the latent variables from the prior predictive distribution of the ensemble model.
}
\details{
The samples are created using the methods described in Strickland et. al. (2009) and Durbin and Koopman (2002).
}
\examples{
\donttest{
priors <- EnsemblePrior(4)
prior_density <- prior_ensemble_model(priors, M = 4)
samples <- sample_prior(observations = list(SSB_obs, Sigma_obs),
             simulators = list(list(SSB_miz, Sigma_miz),
                               list(SSB_ewe, Sigma_ewe),
                               list(SSB_fs, Sigma_fs),
                               list(SSB_lm, Sigma_lm)),
             priors = priors,
             sam_priors = prior_density)
plot(samples) #Plot the prior predictive density.
}
}
\references{
J. Durbin, S. J. Koopman (2002) A simple and efficient simulation smoother for state space time series analysis Biometrika, Volume 89, Issue 3, August 2002, Pages 603-616,

Chris M.Strickland, Ian. W.Turner, RobertDenhamb, Kerrie L.Mengersena. Efficient Bayesian estimation of multivariate state space models Computational Statistics & Data Analysis Volume 53, Issue 12, 1 October 2009, Pages 4116-4125
}
\seealso{
\code{\linkS4class{EnsembleFit}}, \code{\link{EnsembleSample}}, \code{\link{generate_sample}}, \code{\link{prior_ensemble_model}}
}
