% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_ensemble.R
\name{get_mcmc_ensemble_model}
\alias{get_mcmc_ensemble_model}
\title{Return the compiled ensemble model Stan object.}
\usage{
get_mcmc_ensemble_model()
}
\value{
The \code{stanmodel} object encoding the ensemble model.
}
\description{
Gets the unfit, compiled \code{stanmodel} object encoding the ensemble model. This allows for
manual fitting of the ensemble model directly using.
}
\examples{
mod <- get_mcmc_ensemble_model()

priors <- EnsemblePrior(4)
ensemble_data <- EnsembleData(observations = list(SSB_obs, Sigma_obs),
                             simulators = list(list(SSB_ewe, Sigma_ewe, "EwE"),
                                           list(SSB_fs,  Sigma_fs, "FishSUMS"),
                                           list(SSB_lm,  Sigma_lm, "LeMans"),
                                           list(SSB_miz, Sigma_miz, "mizer")),
                              priors = priors)
\donttest{
out <- rstan::sampling(mod, ensemble_data@stan_input, chains = 1)
}
}
