# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Matrix product
#'
#' Standard matrix product. The first matrix must have as many columns as the
#' second has rows.
#'
#' @param MAT1 matrix
#' @param MAT2 matrix
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Standardisation of a matrix
#'
#' Divides each cell of a matrix by its sum, so that the sum of all these
#' cells becomes 1.
#'
#' @param x matrix
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Matrix row bind
#'
#' Binding of two matrices by their row. Both matrices must have the same
#' number of rows.
#'
#' @param MAT1 matrix
#' @param MAT2 matrix
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Matrix col bind
#'
#' Binding of two matrices by their columns. Both matrices must have the same
#' number of columns.
#'
#' @param MAT1 matrix
#' @param MAT2 matrix
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Logical matrix col bind
#'
#' Binding of two logical matrices by their columns. Both matrices must have the same
#' number of columns.
#'
#' @param MAT1 logical matrix
#' @param MAT2 logical matrix
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Sum of a matrix
#'
#' Sum of all the cells of one matrix.
#'
#' @param MAT matrix
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Mean of two matrices
#'
#' Calculates the average of the values of each cell one by one.
#'
#' @param MAT1 matrix
#' @param MAT2 matrix
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Binding matrices on matrices
#'
#' Links to each of the matrices in the REF_LIST list the
#' matrices in the ADD_LIST list, respectively.
#'
#' @param REF_LIST list of reference matrices
#' @param ADD_LIST list of matrices to ve added
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Binding vectors on vectors
#'
#' Links to each of the vectors in the REF_LIST list the
#' vectors in the ADD_LIST list, respectively.
#'
#' @param REF_LIST list of reference vectors
#' @param ADD_LIST list of vectors to ve added
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Importing the multinomial draw function from R into C++
#'
#' @param size number of random vectors to draw.
#' @param probs event probabilites
#' @param N number of trials
#'
NULL

#' Multinomial draw
#'
#' @param n number of trials
#' @param size number of random vectors to draw.
#' @param probs event probabilites
#'
NULL

#' Genetic drift
#'
#' Simulates genetic drift by drawing in a multinomial distribution with the
#' population size as the number of trials and the genotype frequencies as probabilities
#'
#' @param freq genotypic frequencies
#' @param N population size
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Should the simulation stop?
#'
#' Determination from the allele frequencies if the simulation should stop.
#'
#' @param freqAlleles allelic frequencies
#' @param stopCondition list of stop conditions
#'
#' @author Ehouarn Le Faou
#'
NULL

#' What stop conditions has the simulation reached?
#'
#' Determination of the stop condition index or indices that the simulation
#' has reached.
#'
#' @param freqAlleles allelic frequencies
#' @param stopCondition list of stop conditions
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Specify the seed for the RNG
#'
#' Sets the seed for random number generation to ensure repeatability of
#' simulations.
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Crossing of male and female gametes
#'
#' Crossing of male and female gametes by knowing their respective genotype
#' frequencies and thanks to the crossing matrix which allows to determine
#' which genotypes result from each crossing between gametic haplotypes.
#'
#' @param nbHaplo number of haplotypes
#' @param nbGeno number of genotypes
#' @param freqHaploFemale female genotype frequencies
#' @param freqHaploMale male genotype frequencies
#' @param haploCrossMat haplotypes crossing matrix
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Selfing
#'
#' Reproduction of the population by self-fertilization (only if the
#' population is hermaphroditic).
#'
#' @param nbHaplo number of haplotypes
#' @param nbGeno number of genotypes
#' @param freqGeno genotype frequencies
#' @param gametogenesisMat gametogenesis matrix
#' @param haploCrossMat haplotypes crossing matrix
#' @param femgamFit fitness of female gametes
#' @param malegamFit fitness of male gametes
#' @param femProdFit fitness for female gamete production
#' @param maleProdFit fitness for male gamete production
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Outcrossing
#'
#' Reproduction of the population by outcrossing.
#'
#' @param nbHaplo number of haplotypes
#' @param nbGeno number of genotypes
#' @param freqGenoFemale female genotype frequencies
#' @param freqGenoMale male genotype frequencies
#' @param gametogenesisMat gametogenesis matrix
#' @param haploCrossMat haplotypes crossing matrix
#' @param femgamFit fitness of female gametes
#' @param malegamFit fitness of male gametes
#' @param femProdFit fitness for female gamete production
#' @param maleProdFit fitness for male gamete production
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Selection on individuals
#'
#' Selection on individuals (selection on gametes and gamete production is
#' carried out during reproduction).
#'
#' @param nbGeno number of genotypes
#' @param freqGeno genotype frequencies
#' @param fitness fitness of individuals
#'
#' @author Ehouarn Le Faou
#'
NULL

#' Simulation of a metapopulation
#' 
#' @param nbPop number of populations in the metapopulation
#' @param ids population IDs
#' @param migMat migration matrix
#' @param nsim number of simulations
#' @param verbose boolean determining if the progress of the simulations should be displayed or not (useful in case of many simulations)
#' @param recording a boolean indicating whether to record all mutations, i.e.
#' to record allelic and genotypic frequencies along the simulations
#' @param recordGenGap the number of generations between two records during
#' simulation, if the record parameter is TRUE. Whatever the value of this
#' parameter, both the first and the last generation will be included in
#' the record
#' @param drift a boolean indicating whether genetic drift should be
#' considered (i.e. whether deterministic simulations are performed or not)
#' @param nbHaplo number of haplotypes
#' @param nbGeno number of genotypes
#' @param idGeno genotypes ID
#' @param nbAlleles number of alleles for each loci
#' @param idAlleles alleles ID
#' @param nbLoci number of loci
#' @param initGenoFreq list of initial genotype frequencies in the populations
#' @param meiosisMat meiosis matrix
#' @param gametogenesisMat gametogenesis matrix
#' @param popSize list population sizes
#' @param threshold threshold for simulations
#' @param dioecy whether the population(s) is dioecious or not (hermaphrodism)
#' @param selfRate list of the selfing rate in populations (only for hermaphroditic population)
#' @param stopCondition list of stop conditions
#' @param IDstopCondition vector of stop condition ID
#' @param haploCrossMat haplotypes crossing matrix
#' @param alleleFreqMat matrix for calculating allelic frequencies
#' @param gamFit fitness of gametes
#' @param indFit fitness of individuals
#' @param gamProdFit fitness for gamete production
#' @param demography list of population demographies
#' @param growthRate list of population growth rates
#' @param initPopSize list of initial population
#' @param nameOutFunct name of the custom output function
#'
#' @author Ehouarn Le Faou
#'
METAPOP_SIMULATION <- function(nbPop, ids, migMat, nsim, verbose, recording, recordGenGap, drift, nbHaplo, nbGeno, idGeno, nbAlleles, idAlleles, nbLoci, initGenoFreq, meiosisMat, gametogenesisMat, popSize, threshold, dioecy, selfRate, stopCondition, IDstopCondition, haploCrossMat, alleleFreqMat, gamFit, indFit, gamProdFit, demography, growthRate, initPopSize, nameOutFunct) {
    .Call(`_Ease_METAPOP_SIMULATION`, nbPop, ids, migMat, nsim, verbose, recording, recordGenGap, drift, nbHaplo, nbGeno, idGeno, nbAlleles, idAlleles, nbLoci, initGenoFreq, meiosisMat, gametogenesisMat, popSize, threshold, dioecy, selfRate, stopCondition, IDstopCondition, haploCrossMat, alleleFreqMat, gamFit, indFit, gamProdFit, demography, growthRate, initPopSize, nameOutFunct)
}

