% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SIMULATION_MULTIPLE}
\alias{SIMULATION_MULTIPLE}
\title{Simulate the model multiple times}
\usage{
SIMULATION_MULTIPLE(
  nsim,
  recording,
  recordGenGap,
  drift,
  nbHaplo,
  nbGeno,
  nbAlleles,
  initGenoFreq,
  gametogenesisMat,
  N,
  threshold,
  dioecy,
  selfRate,
  stopCondition,
  haploCrossMat,
  alleleFreqMat,
  femgamFit,
  malegamFit,
  femindFit,
  maleindFit,
  indFit,
  femProdFit,
  maleProdFit,
  verbose
)
}
\arguments{
\item{nsim}{number of simulations}

\item{recording}{a boolean indicating whether to record all mutations, i.e.
to record allelic and genotypic frequencies along the simulations}

\item{recordGenGap}{the number of generations between two records during
simulation, if the record parameter is TRUE. Whatever the value of this
parameter, both the first and the last generation will be included in
the record}

\item{drift}{a boolean indicating whether genetic drift should be
considered (i.e. whether deterministic simulations are performed or not)}

\item{nbHaplo}{number of haplotypes}

\item{nbGeno}{number of genotypes}

\item{nbAlleles}{number of alleles for each loci}

\item{initGenoFreq}{initial genotype frequencies}

\item{gametogenesisMat}{gametogenesis matrix}

\item{N}{population size}

\item{threshold}{threshold for simulations}

\item{dioecy}{whether the population is dioecious or not (hermaphrodism)}

\item{selfRate}{selfing rate (only for hermaphroditic population)}

\item{stopCondition}{list of stop conditions}

\item{haploCrossMat}{haplotypes crossing matrix}

\item{alleleFreqMat}{matrix for calculating allelic frequencies}

\item{femgamFit}{fitness of female gametes}

\item{malegamFit}{fitness of male gametes}

\item{femindFit}{fitness of female individuals}

\item{maleindFit}{fitness of male individuals}

\item{indFit}{fitness of individuals (only for hermaphroditic population)}

\item{femProdFit}{fitness for female gamete production}

\item{maleProdFit}{fitness for male gamete production}

\item{verbose}{boolean determining if the progress of the simulations should be displayed or not (useful in case of many simulations)}
}
\value{
Each simulation is described by data.frame where each line corresponds to a generation (by default,
otherwise according to the \code{recordGenGap} parameter of the \code{simulate} method). The first one(s) describe(s)
the genotypic frequencies at the end of the simulations of the individuals in the case of a hermaphroditic population
or of the females then of the males in the case of a dioecious population. Then there are in order: the allelic
frequencies at the end of the simulations, the generations where the simulations stopped, the stop conditions reached.
Then there are the lists of records where each simulation is described by a data.frame where each line is a generation.
The record lists correspond to the genotypic frequencies, the allelic frequencies and finally the generations.
}
\description{
Simulation of the model multiple times with all the necessary parameters
set.
}
\author{
Ehouarn Le Faou
}
