% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EValue.R
\name{evalues.MD}
\alias{evalues.MD}
\title{Compute E-value for a difference of means and its confidence interval limits}
\usage{
evalues.MD(est, se = NA, true = 0, ...)
}
\arguments{
\item{est}{The point estimate as a standardized difference (i.e., Cohen's d)}

\item{se}{The standard error of the point estimate}

\item{true}{The true standardized mean difference to which to shift the
observed point estimate. Typically set to 0 to consider a null true effect.}

\item{...}{Arguments passed to other methods.}
}
\description{
Returns a data frame containing point estimates, the lower confidence limit,
and the upper confidence limit on the risk ratio scale (through an
approximate conversion) as well as E-values for the point estimate and the
confidence interval limit closer to the null.
}
\details{
Regarding the continuous outcome, the function uses the effect-size conversions in Chinn (2000)
and VanderWeele (2017) to approximately convert the mean difference between the exposed versus unexposed groups
to the odds ratio that would arise from dichotomizing the continuous outcome.

For example, if resulting E-value is 2, this means that unmeasured confounder(s) would need to double
the probability of a subject's being exposed versus not being exposed, and would also need to
double the probability of being high versus low on the outcome, in which the cutoff for "high" versus
"low" is arbitrary subject to some distributional assumptions (Chinn, 2000).
}
\examples{
# compute E-value if Cohen's d = 0.5 with SE = 0.25
evalues.MD(.5, .25)
}
\references{
Chinn, S (2000). A simple method for converting an odds ratio to effect size for use in meta-analysis. \emph{Statistics in Medicine}, 19(22), 3127-3131.

VanderWeele, TJ (2017). On a square-root transformation of the odds ratio for a common outcome. \emph{Epidemiology}, 28(6), e58.
}
\keyword{e-value}
